/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushRequestImpl
extends AbstractMessage
implements PushRequest {
    private static final int STANDARD_PAYLOAD_SIZE = 26;
    private static final GGEP NULL_GGEP = new GGEP();
    private byte[] payload;
    private GGEP ggep;

    public PushRequestImpl(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, (byte)64, ttl, hops, payload.length, network);
        if (payload.length < 26) {
            throw new BadPacketException("Payload too small: " + payload.length);
        }
        this.payload = payload;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            throw new BadPacketException("invalid port");
        }
        String ip = NetworkUtils.ip2string(payload, 20);
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new BadPacketException("invalid address: " + ip);
        }
    }

    public PushRequestImpl(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port) {
        this(guid, ttl, clientGUID, index, ip, port, Message.Network.UNKNOWN);
    }

    public PushRequestImpl(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port, Message.Network network) {
        this(guid, ttl, clientGUID, index, ip, port, network, false);
    }

    public PushRequestImpl(byte[] guid, byte ttl, byte[] clientGUID, long index, byte[] ip, int port, Message.Network network, boolean useTLS) {
        super(guid, (byte)64, ttl, (byte)0, 0, network);
        if (clientGUID.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + clientGUID.length);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + ip.length);
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("invalid ip " + NetworkUtils.ip2string(ip));
        }
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        byte[] extra = DataUtils.EMPTY_BYTE_ARRAY;
        if (useTLS) {
            extra = PushGGEPHelper.TLS_GGEP;
        }
        int payloadSize = 26 + extra.length;
        this.payload = new byte[payloadSize];
        System.arraycopy(clientGUID, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)index, this.payload, 16);
        this.payload[20] = ip[0];
        this.payload[21] = ip[1];
        this.payload[22] = ip[2];
        this.payload[23] = ip[3];
        ByteOrder.short2leb((short)port, this.payload, 24);
        System.arraycopy(extra, 0, this.payload, 26, extra.length);
        this.updateLength(payloadSize);
    }

    @Override
    public boolean isTLSCapable() {
        this.parseGGEP();
        if (this.ggep != null && this.ggep != NULL_GGEP) {
            return this.ggep.hasKey("TLS");
        }
        return false;
    }

    private void parseGGEP() {
        if (this.ggep == null && this.payload.length > 26) {
            try {
                this.ggep = new GGEP(this.payload, 26);
            }
            catch (BadGGEPBlockException e) {
                this.ggep = NULL_GGEP;
            }
        }
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.payload);
    }

    @Override
    public byte[] getClientGUID() {
        byte[] ret = new byte[16];
        System.arraycopy(this.payload, 0, ret, 0, 16);
        return ret;
    }

    @Override
    public long getIndex() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this.payload, 16));
    }

    @Override
    public boolean isFirewallTransferPush() {
        return this.getIndex() == 0x7FFFFFFDL;
    }

    @Override
    public byte[] getIP() {
        byte[] ret = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return ret;
    }

    @Override
    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this.payload, 24));
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return PushRequest.class;
    }

    @Override
    public String toString() {
        return "PushRequest(" + super.toString() + " " + NetworkUtils.ip2string(this.getIP()) + ":" + this.getPort() + ")";
    }

    private static class PushGGEPHelper {
        private static final byte[] TLS_GGEP;

        private PushGGEPHelper() {
        }

        static {
            GGEP tlsGGEP = new GGEP();
            tlsGGEP.put("TLS");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                tlsGGEP.write(out);
            }
            catch (IOException impossible) {
                ErrorService.error(impossible);
            }
            TLS_GGEP = out.toByteArray();
        }
    }
}

