/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.GGEPParser;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyData;
import com.limegroup.gnutella.messages.SecureGGEPData;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.HostDataFactory;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.limewire.collection.BitNumbers;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IPPortCombo;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryReplyImpl
extends AbstractMessage
implements QueryReply {
    private static final byte PUSH_MASK = 1;
    private static final byte BUSY_MASK = 4;
    private static final byte UPLOADED_MASK = 8;
    private static final byte SPEED_MASK = 16;
    static final byte GGEP_MASK = 32;
    private static final byte CHAT_MASK = 1;
    private static final GGEPUtil _ggepUtil = new GGEPUtil();
    private byte[] _payload;
    private byte[] _address = new byte[4];
    private int _secureStatus = 0;
    private boolean _parsed = false;
    private volatile QueryReplyData _data;
    private volatile boolean _multicastAllowed = false;
    private byte[] clientGUID = null;
    private final HostDataFactory hostDataFactory;
    private final ResponseFactory responseFactory;
    private final boolean local;

    QueryReplyImpl(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network, HostDataFactory hostDataFactory, ResponseFactory responseFactory) throws BadPacketException {
        super(guid, (byte)-127, ttl, hops, payload.length, network);
        this.hostDataFactory = hostDataFactory;
        this.responseFactory = responseFactory;
        this._payload = payload;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            throw new BadPacketException("invalid port");
        }
        if ((this.getSpeed() & 0xFFFFFFFF00000000L) != 0L) {
            throw new BadPacketException("invalid speed: " + this.getSpeed());
        }
        this.setAddress();
        if (!NetworkUtils.isValidAddress(this.getIPBytes())) {
            throw new BadPacketException("invalid address");
        }
        this.local = false;
    }

    QueryReplyImpl(byte[] guid, byte ttl, int port, byte[] ip, long speed, Response[] responses, byte[] clientGUID, byte[] xmlBytes, boolean includeQHD, boolean needsPush, boolean isBusy, boolean finishedUpload, boolean measuredSpeed, boolean supportsChat, boolean supportsBH, boolean isMulticastReply, boolean supportsFWTransfer, Set<? extends IpPort> proxies, SecurityToken securityToken, HostDataFactory hostDataFactory, ResponseFactory responseFactory) {
        super(guid, (byte)-127, ttl, (byte)0, 0, Message.Network.UNKNOWN);
        this.hostDataFactory = hostDataFactory;
        this.responseFactory = responseFactory;
        this.local = true;
        if (xmlBytes.length > 32768) {
            throw new IllegalArgumentException("xml too large: " + new String(xmlBytes));
        }
        int n = responses.length;
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (ip.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + ip.length);
        }
        if (!NetworkUtils.isValidAddress(ip)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(ip));
        }
        if ((speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (n >= 256) {
            throw new IllegalArgumentException("invalid num responses: " + n);
        }
        this._data = new QueryReplyData();
        this._data.setXmlBytes(xmlBytes);
        this._data.setProxies(proxies);
        this._data.setSupportsFWTransfer(supportsFWTransfer);
        this._data.setSecurityToken(securityToken != null ? securityToken.getBytes() : null);
        boolean supportsTLS = SSLSettings.isIncomingTLSEnabled();
        this._data.setTLSCapable(supportsTLS);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(n);
            ByteOrder.short2leb((short)port, baos);
            baos.write(ip, 0, ip.length);
            ByteOrder.int2leb((int)speed, baos);
            for (int left = n; left > 0; --left) {
                Response r = responses[n - left];
                r.writeToStream(baos);
            }
            if (includeQHD || securityToken != null) {
                baos.write(76);
                baos.write(73);
                baos.write(77);
                baos.write(69);
                baos.write(4);
                int ggepLen = _ggepUtil.getQRGGEP(false, false, false, false, IpPort.EMPTY_SET, null).length;
                boolean hasProxies = proxies != null && proxies.size() > 0;
                byte flags = (byte)((needsPush && !isMulticastReply ? 1 : 0) | 4 | 8 | 0x10 | 0x20);
                byte controls = (byte)(1 | (isBusy && !isMulticastReply ? 4 : 0) | (finishedUpload ? 8 : 0) | (measuredSpeed || isMulticastReply ? 16 : 0) | (supportsBH || isMulticastReply || hasProxies || supportsFWTransfer || securityToken != null || supportsTLS ? 32 : (ggepLen > 0 ? 32 : 0)));
                baos.write(flags);
                baos.write(controls);
                int xmlSize = xmlBytes.length + 1;
                if (xmlSize > 32768) {
                    xmlSize = 32768;
                }
                ByteOrder.short2leb((short)xmlSize, baos);
                int chatSupport = supportsChat ? 1 : 0;
                baos.write(chatSupport);
                byte[] ggepBytes = _ggepUtil.getQRGGEP(supportsBH, isMulticastReply, supportsFWTransfer, supportsTLS, proxies, securityToken);
                baos.write(ggepBytes, 0, ggepBytes.length);
                this.writeSecureGGEP(baos, xmlBytes);
                baos.write(xmlBytes, 0, xmlBytes.length);
                baos.write(0);
            }
            baos.write(clientGUID, 0, 16);
            this._payload = baos.toByteArray();
            this.updateLength(this._payload.length);
        }
        catch (IOException reallyBad) {
            ErrorService.error(reallyBad);
        }
        this.setAddress();
    }

    protected void writeSecureGGEP(ByteArrayOutputStream out, byte[] xml) {
    }

    private void setAddress() {
        this._address[0] = this._payload[3];
        this._address[1] = this._payload[4];
        this._address[2] = this._payload[5];
        this._address[3] = this._payload[6];
    }

    @Override
    public void setOOBAddress(InetAddress addr, int port) {
        this._address = addr.getAddress();
        ByteOrder.short2leb((short)port, this._payload, 1);
    }

    @Override
    public void setGUID(GUID guid) {
        super.setGUID(guid);
    }

    @Override
    public void writePayload(OutputStream out) throws IOException {
        out.write(this._payload);
    }

    @Override
    public void setBrowseHostReply(boolean isBH) {
        this.parseResults();
        this._data.setBrowseHostReply(isBH);
    }

    @Override
    public boolean isBrowseHostReply() {
        this.parseResults();
        return this._data.isBrowseHostReply();
    }

    @Override
    public byte[] getXMLBytes() {
        this.parseResults();
        return this._data.getXmlBytes();
    }

    @Override
    public short getResultCount() {
        return (short)ByteOrder.ubyte2int(this._payload[0]);
    }

    @Override
    public short getPartialResultCount() {
        this.parseResults();
        return this._data.getPartialResultCount();
    }

    @Override
    public short getUniqueResultCount() {
        this.parseResults();
        return this._data.getUniqueResultURNs();
    }

    @Override
    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this._payload, 1));
    }

    @Override
    public String getIP() {
        return NetworkUtils.ip2string(this._address);
    }

    @Override
    public byte[] getIPBytes() {
        return this._address;
    }

    @Override
    public long getSpeed() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this._payload, 7));
    }

    @Override
    public Response[] getResultsArray() throws BadPacketException {
        this.parseResults();
        Response[] responses = this._data.getResponses();
        if (responses == null) {
            throw new BadPacketException();
        }
        return responses;
    }

    @Override
    public Iterator<Response> getResults() throws BadPacketException {
        return this.getResultsAsList().iterator();
    }

    @Override
    public List<Response> getResultsAsList() throws BadPacketException {
        return Arrays.asList(this.getResultsArray());
    }

    @Override
    public String getVendor() throws BadPacketException {
        this.parseResults();
        String vendor = this._data.getVendor();
        if (vendor == null) {
            throw new BadPacketException();
        }
        return vendor;
    }

    @Override
    public boolean getNeedsPush() throws BadPacketException {
        this.parseResults();
        switch (this._data.getPushFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for push flag: " + this._data.getPushFlag());
    }

    @Override
    public boolean getIsBusy() throws BadPacketException {
        this.parseResults();
        switch (this._data.getBusyFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for busy flag: " + this._data.getBusyFlag());
    }

    @Override
    public boolean getHadSuccessfulUpload() throws BadPacketException {
        this.parseResults();
        switch (this._data.getUploadedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for uploaded flag: " + this._data.getUploadedFlag());
    }

    @Override
    public boolean getIsMeasuredSpeed() throws BadPacketException {
        this.parseResults();
        switch (this._data.getMeasuredSpeedFlag()) {
            case -1: {
                throw new BadPacketException();
            }
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalStateException("Bad value for measured speed flag: " + this._data.getMeasuredSpeedFlag());
    }

    @Override
    public byte[] getSecureSignature() {
        this.parseResults();
        SecureGGEPData sg = this._data.getSecureGGEP();
        if (sg != null) {
            try {
                return sg.getGGEP().getBytes("SIG");
            }
            catch (BadGGEPPropertyException bgpe) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void updateSignatureWithSecuredBytes(Signature signature) throws SignatureException {
        this.parseResults();
        SecureGGEPData sg = this._data.getSecureGGEP();
        if (sg != null) {
            signature.update(this._payload, 0, sg.getStartIndex());
            int end = sg.getEndIndex();
            int length = this._payload.length - 16 - end;
            signature.update(this._payload, end, length);
        }
    }

    @Override
    public synchronized int getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public synchronized void setSecureStatus(int secureStatus) {
        this._secureStatus = secureStatus;
    }

    @Override
    public boolean isTLSCapable() {
        this.parseResults();
        return this._data.isTLSCapable();
    }

    @Override
    public boolean getSupportsChat() {
        this.parseResults();
        return this._data.isSupportsChat();
    }

    @Override
    public boolean getSupportsFWTransfer() {
        this.parseResults();
        return this._data.isSupportsFWTransfer();
    }

    @Override
    public byte getFWTransferVersion() {
        this.parseResults();
        return this._data.getFwTransferVersion();
    }

    @Override
    public boolean getSupportsBrowseHost() {
        this.parseResults();
        return this._data.isSupportsBrowseHost();
    }

    @Override
    public boolean isReplyToMulticastQuery() {
        this.parseResults();
        return this._multicastAllowed && this._data.isReplyToMulticast();
    }

    @Override
    public void setMulticastAllowed(boolean allowed) {
        this._multicastAllowed = allowed;
    }

    @Override
    public boolean isFakeMulticast() {
        this.parseResults();
        return !this._multicastAllowed && this._data.isReplyToMulticast();
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        this.parseResults();
        return this._data.getProxies();
    }

    @Override
    public byte[] getSecurityToken() {
        this.parseResults();
        return this._data.getSecurityToken();
    }

    @Override
    public HostData getHostData() throws BadPacketException {
        this.parseResults();
        HostData hd = this._data.getHostData();
        if (hd == null) {
            throw new BadPacketException();
        }
        return hd;
    }

    @Override
    public boolean hasSecureData() {
        this.parseResults();
        return this._data.getSecureGGEP() != null;
    }

    private synchronized void parseResults() {
        if (this._parsed) {
            return;
        }
        this._parsed = true;
        this.parseResults2();
    }

    private void parseResults2() {
        int i = 11;
        this._data = new QueryReplyData();
        int left = this.getResultCount();
        if (left > FilterSettings.MAX_RESPONSES_PER_REPLY.getValue()) {
            return;
        }
        Response[] responses = new Response[left];
        HashSet<URN> urns = new HashSet<URN>(responses.length);
        short uniqueURNs = 0;
        int partialURNs = 0;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this._payload, i, this._payload.length - i);
            while (left > 0) {
                Response r = this.responseFactory.createFromStream(bais);
                if (r.getRanges() != null && r.getRanges().getSize() > 0L) {
                    partialURNs = (short)(partialURNs + 1);
                }
                responses[responses.length - left] = r;
                i += r.getIncomingLength();
                if (r.getUrns().isEmpty()) {
                    uniqueURNs = (short)(uniqueURNs + 1);
                } else {
                    urns.addAll(r.getUrns());
                }
                --left;
            }
            this._data.setResponses(responses);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        uniqueURNs = (short)(uniqueURNs + (short)urns.size());
        this._data.setUniqueResultURNs(uniqueURNs);
        this._data.setPartialResultCount((short)Math.min(uniqueURNs, partialURNs));
        try {
            int privateLength;
            if (i >= this._payload.length - 16) {
                throw new BadPacketException("No QHD");
            }
            String vendorT = null;
            int pushFlagT = -1;
            int busyFlagT = -1;
            int uploadedFlagT = -1;
            int measuredSpeedFlagT = -1;
            boolean supportsChatT = false;
            boolean supportsBrowseHostT = false;
            boolean replyToMulticastT = false;
            Set<IpPort> proxies = IpPort.EMPTY_SET;
            byte[] securityToken = null;
            boolean supportsTLST = false;
            try {
                vendorT = new String(this._payload, i, 4, "ISO-8859-1");
                assert (vendorT.length() == 4) : "Vendor length wrong.  Wrong character encoding?";
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("No support for ISO-8859-1 encoding");
            }
            int length = ByteOrder.ubyte2int(this._payload[i += 4]);
            if (length <= 0) {
                throw new BadPacketException("Common payload length zero.");
            }
            if (++i + length > this._payload.length - 16) {
                throw new BadPacketException("Common payload length imprecise!");
            }
            this._data.setQHDOffset(i - 1);
            if (length > 1) {
                byte control = this._payload[i];
                byte flags = this._payload[i + 1];
                if ((flags & 1) != 0) {
                    int n = pushFlagT = (control & 1) == 1 ? 1 : 0;
                }
                if ((control & 4) != 0) {
                    int n = busyFlagT = (flags & 4) != 0 ? 1 : 0;
                }
                if ((control & 8) != 0) {
                    int n = uploadedFlagT = (flags & 8) != 0 ? 1 : 0;
                }
                if ((control & 0x10) != 0) {
                    int n = measuredSpeedFlagT = (flags & 0x10) != 0 ? 1 : 0;
                }
                if ((control & 0x20) != 0 && (flags & 0x20) != 0) {
                    GGEPParser parser = new GGEPParser();
                    parser.scanForGGEPs(this._payload, i + 2);
                    GGEP ggep = parser.getNormalGGEP();
                    if (ggep != null) {
                        this._data.setGGEPStart(parser.getNormalStartIndex());
                        this._data.setGGEPEnd(parser.getNormalEndIndex());
                        try {
                            supportsBrowseHostT = ggep.hasKey("BH");
                            if (ggep.hasKey("FW")) {
                                this._data.setFwTransferVersion(ggep.getBytes("FW")[0]);
                                this._data.setSupportsFWTransfer(this._data.getFwTransferVersion() > 0);
                            }
                            replyToMulticastT = ggep.hasKey("MCAST");
                            proxies = _ggepUtil.getPushProxies(ggep);
                            if (ggep.hasKey("SO") && ((securityToken = ggep.getBytes("SO")) == null || securityToken.length == 0)) {
                                throw new BadPacketException("Message had empty OOB security token");
                            }
                            supportsTLST = ggep.hasKey("TLS");
                        }
                        catch (BadGGEPPropertyException bgpe) {
                            // empty catch block
                        }
                    }
                    if (parser.getSecureGGEP() != null) {
                        this._data.setSecureGGEP(new SecureGGEPData(parser));
                    }
                }
                i += 2;
            }
            if (length > 2) {
                int b;
                int temp;
                int a;
                int xmlSize;
                if ((xmlSize = (a = (temp = ByteOrder.ubyte2int(this._payload[i++]))) | (b = (temp = ByteOrder.ubyte2int(this._payload[i++])) << 8)) > 1) {
                    int xmlInPayloadIndex = this._payload.length - 16 - xmlSize;
                    byte[] xmlBytes = new byte[xmlSize - 1];
                    System.arraycopy(this._payload, xmlInPayloadIndex, xmlBytes, 0, xmlSize - 1);
                    this._data.setXmlBytes(xmlBytes);
                } else {
                    this._data.setXmlBytes(DataUtils.EMPTY_BYTE_ARRAY);
                }
            }
            if ((privateLength = this._payload.length - i) > 0 && (vendorT.equals("LIME") || vendorT.equals("RAZA"))) {
                byte privateFlags = this._payload[i];
                boolean bl = supportsChatT = (privateFlags & 1) != 0;
            }
            if (i > this._payload.length - 16) {
                throw new BadPacketException("Common payload length too large.");
            }
            this._data.setVendor(vendorT.toUpperCase(Locale.US));
            this._data.setPushFlag(pushFlagT);
            this._data.setBusyFlag(busyFlagT);
            this._data.setUploadedFlag(uploadedFlagT);
            this._data.setMeasuredSpeedFlag(measuredSpeedFlagT);
            this._data.setSupportsChat(supportsChatT);
            this._data.setSupportsBrowseHost(supportsBrowseHostT);
            this._data.setReplyToMulticast(replyToMulticastT);
            this._data.setProxies(proxies);
            this._data.setSecurityToken(securityToken);
            this._data.setTLSCapable(supportsTLST);
            this._data.setHostData(this.hostDataFactory.createHostData(this));
        }
        catch (BadPacketException e) {
            return;
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
    }

    @Override
    public byte[] getClientGUID() {
        if (this.clientGUID == null) {
            byte[] result = new byte[16];
            int length = super.getLength();
            System.arraycopy(this._payload, length - 16, result, 0, 16);
            this.clientGUID = result;
        }
        return this.clientGUID;
    }

    @Override
    public byte[] getPayload() {
        return this._payload;
    }

    @Override
    public String toString() {
        return "QueryReply::\r\n" + this.getResultCount() + " hits\r\n" + super.toString() + "\r\n" + "ip: " + this.getIP() + "\r\n";
    }

    @Override
    public int calculateQualityOfService(boolean iFirewalled, NetworkManager networkManager) {
        int heFirewalled;
        int busy;
        boolean YES = true;
        boolean MAYBE = false;
        int NO = -1;
        try {
            busy = this.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException e) {
            busy = 0;
        }
        boolean isMCastReply = this.isReplyToMulticastQuery();
        if (isMCastReply) {
            iFirewalled = false;
            heFirewalled = -1;
        } else if (networkManager.isPrivateAddress(this.getIPBytes())) {
            heFirewalled = 1;
        } else {
            try {
                heFirewalled = this.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException e) {
                heFirewalled = 0;
            }
        }
        boolean hasPushProxies = false;
        if (this.getPushProxies() != null && this.getPushProxies().size() > 1) {
            hasPushProxies = true;
        }
        if (this.getSupportsFWTransfer() && networkManager.canDoFWT()) {
            iFirewalled = false;
            heFirewalled = -1;
        }
        if (Arrays.equals(this._address, networkManager.getAddress())) {
            return 3;
        }
        if (isMCastReply) {
            return 4;
        }
        if (iFirewalled && heFirewalled == 1) {
            return -1;
        }
        if (busy == 0 || heFirewalled == 0) {
            return 0;
        }
        if (busy == 1) {
            assert (heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1) {
                return 0;
            }
            return 1;
        }
        if (busy == -1) {
            assert (heFirewalled == -1 || !iFirewalled);
            if (heFirewalled == 1 && !hasPushProxies) {
                return 2;
            }
            return 3;
        }
        assert (false) : "Unexpected case!";
        return -1;
    }

    public static boolean isFirewalledQuality(int quality) {
        return quality == 0 || quality == 2;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return QueryReply.class;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    int getGGEPStart() {
        this.parseResults();
        return this._data.getGGEPStart();
    }

    int getGGEPEnd() {
        this.parseResults();
        return this._data.getGGEPEnd();
    }

    int getQHDOffset() {
        this.parseResults();
        return this._data.getQHDOffset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GGEPUtil {
        private final byte[] _standardGGEP;
        private final byte[] _bhGGEP;
        private final byte[] _bhTLSGGEP;
        private final byte[] _mcGGEP;
        private final byte[] _mcTLSGGEP;
        private final byte[] _bhAndMC;
        private final byte[] _bhMCAndTLS;
        private final byte[] _tlsGGEP;

        public GGEPUtil() {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this._standardGGEP = this.create(out, new String[0]);
            this._bhGGEP = this.create(out, "BH");
            this._mcGGEP = this.create(out, "MCAST");
            this._mcTLSGGEP = this.create(out, "MCAST", "TLS");
            this._bhAndMC = this.create(out, "BH", "MCAST");
            this._bhTLSGGEP = this.create(out, "BH", "TLS");
            this._bhMCAndTLS = this.create(out, "BH", "MCAST", "TLS");
            this._tlsGGEP = this.create(out, "TLS");
        }

        private byte[] create(ByteArrayOutputStream out, String ... headers) {
            out.reset();
            GGEP combo = new GGEP(true);
            for (String header : headers) {
                combo.put(header);
            }
            try {
                combo.write(out);
            }
            catch (IOException writeError) {
                // empty catch block
            }
            byte[] data = out.toByteArray();
            assert (data != null);
            return data;
        }

        public byte[] getQRGGEP(boolean supportsBH, boolean isMulticastResponse, boolean supportsFWTransfer, boolean supportsTLS, Set<? extends IpPort> proxies, SecurityToken securityToken) {
            byte[] retGGEPBlock = this._standardGGEP;
            if (proxies != null && !proxies.isEmpty() || securityToken != null) {
                if (proxies == null) {
                    proxies = Collections.emptySet();
                }
                int MAX_PROXIES = 4;
                GGEP retGGEP = new GGEP(true);
                if (supportsBH) {
                    retGGEP.put("BH");
                }
                if (isMulticastResponse) {
                    retGGEP.put("MCAST");
                }
                if (supportsTLS) {
                    retGGEP.put("TLS");
                }
                if (supportsFWTransfer) {
                    retGGEP.put("FW", new byte[]{1});
                }
                if (securityToken != null) {
                    retGGEP.put("SO", securityToken.getBytes());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int numWritten = 0;
                BitNumbers bn = HTTPHeaderUtils.getTLSIndices(proxies, Math.min(4, proxies.size()));
                if (!proxies.isEmpty()) {
                    Iterator<IpPort> iter = proxies.iterator();
                    while (iter.hasNext() && numWritten < 4) {
                        IpPort ppi = iter.next();
                        IPPortCombo combo = new IPPortCombo(ppi.getInetSocketAddress());
                        try {
                            baos.write(combo.toBytes());
                            ++numWritten;
                        }
                        catch (IOException ignored) {}
                    }
                }
                try {
                    if (numWritten > 0) {
                        retGGEP.put("PUSH", baos.toByteArray());
                        if (!bn.isEmpty()) {
                            retGGEP.put("PUSH_TLS", bn.toByteArray());
                        }
                    }
                    baos.reset();
                    retGGEP.write(baos);
                    retGGEPBlock = baos.toByteArray();
                }
                catch (IOException ignored) {}
            } else {
                retGGEPBlock = supportsBH && isMulticastResponse && supportsTLS ? this._bhMCAndTLS : (supportsBH && isMulticastResponse ? this._bhAndMC : (supportsBH && supportsTLS ? this._bhTLSGGEP : (supportsBH ? this._bhGGEP : (isMulticastResponse && supportsTLS ? this._mcTLSGGEP : (isMulticastResponse ? this._mcGGEP : (supportsTLS ? this._tlsGGEP : this._standardGGEP))))));
            }
            return retGGEPBlock;
        }

        public Set<? extends IpPort> getPushProxies(GGEP ggep) {
            IpPortSet proxies = null;
            BitNumbers bn = null;
            if (ggep.hasKey("PUSH_TLS")) {
                try {
                    bn = new BitNumbers(ggep.getBytes("PUSH_TLS"));
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            if (ggep.hasKey("PUSH")) {
                try {
                    byte[] proxyBytes = ggep.getBytes("PUSH");
                    ByteArrayInputStream bais = new ByteArrayInputStream(proxyBytes);
                    int i = 0;
                    while (bais.available() > 0) {
                        byte[] combo = new byte[6];
                        if (bais.read(combo, 0, combo.length) == combo.length) {
                            try {
                                if (proxies == null) {
                                    proxies = new IpPortSet();
                                }
                                IpPort ipp = IPPortCombo.getCombo(combo);
                                if (bn != null && bn.isSet(i)) {
                                    ipp = new ConnectableImpl(ipp, true);
                                }
                                proxies.add(ipp);
                            }
                            catch (InvalidDataException malformedPair) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                catch (BadGGEPPropertyException bad) {
                    // empty catch block
                }
            }
            return proxies != null ? proxies : IpPort.EMPTY_SET;
        }
    }
}

