/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.QueryRequestImpl;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.Set;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.util.I18NConvert;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueryRequestFactoryImpl
implements QueryRequestFactory {
    private final NetworkManager networkManager;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MACCalculatorRepositoryManager MACCalculatorRepositoryManager;

    @Inject
    public QueryRequestFactoryImpl(NetworkManager networkManager, LimeXMLDocumentFactory limeXMLDocumentFactory, MACCalculatorRepositoryManager MACCalculatorRepositoryManager2) {
        this.networkManager = networkManager;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.MACCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
    }

    @Override
    public QueryRequest createRequery(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        UrnSet sha1Set = new UrnSet(sha1);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(true), (byte)6, "\\", "", sha1Set, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(URN sha1) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        UrnSet sha1Set = new UrnSet(sha1);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, "\\", "", sha1Set, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(URN sha1, String filename) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (filename == null) {
            throw new NullPointerException("null query");
        }
        if (filename.length() == 0) {
            filename = "\\";
        }
        UrnSet sha1Set = new UrnSet(sha1);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, filename, "", sha1Set, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createRequery(URN sha1, byte ttl) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (ttl <= 0 || ttl > 6) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        UrnSet sha1Set = new UrnSet(sha1);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(true), ttl, "\\", "", sha1Set, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQuery(Set<? extends URN> urnSet) {
        if (urnSet == null) {
            throw new NullPointerException("null urnSet");
        }
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)6, "\\", "", urnSet, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createRequery(String query) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return this.create(QueryRequestImpl.newQueryGUID(true), query);
    }

    @Override
    public QueryRequest createQuery(String query) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), query);
    }

    @Override
    public QueryRequest createOutOfBandQuery(byte[] guid, String query, String xmlQuery) {
        query = I18NConvert.instance().getNorm(query);
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(guid, (byte)6, query, xmlQuery, true);
    }

    @Override
    public QueryRequest createOutOfBandQuery(byte[] guid, String query, String xmlQuery, MediaType type) {
        query = I18NConvert.instance().getNorm(query);
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(guid, (byte)6, query, xmlQuery, true, type);
    }

    @Override
    public QueryRequest createOutOfBandQuery(String query, byte[] ip, int port) {
        byte[] guid = GUID.makeAddressEncodedGuid(ip, port);
        return this.createOutOfBandQuery(guid, query, "");
    }

    @Override
    public QueryRequest createWhatIsNewQuery(byte[] guid, byte ttl) {
        return this.createWhatIsNewQuery(guid, ttl, null);
    }

    @Override
    public QueryRequest createWhatIsNewQuery(byte[] guid, byte ttl, MediaType type) {
        if (ttl < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return this.createQueryRequest(guid, ttl, "WhatIsNewXOXO", "", null, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 1, false, this.getMetaFlag(type));
    }

    @Override
    public QueryRequest createWhatIsNewOOBQuery(byte[] guid, byte ttl) {
        return this.createWhatIsNewOOBQuery(guid, ttl, null);
    }

    @Override
    public QueryRequest createWhatIsNewOOBQuery(byte[] guid, byte ttl, MediaType type) {
        if (ttl < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return this.createQueryRequest(guid, ttl, "WhatIsNewXOXO", "", null, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, true, 1, false, this.getMetaFlag(type));
    }

    @Override
    public QueryRequest createQuery(String query, String xmlQuery) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), query, xmlQuery);
    }

    @Override
    public QueryRequest createQuery(String query, byte ttl) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (ttl <= 0 || ttl > 6) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        return this.create(QueryRequestImpl.newQueryGUID(false), ttl, query);
    }

    @Override
    public QueryRequest createQuery(byte[] guid, String query, String xmlQuery) {
        query = I18NConvert.instance().getNorm(query);
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(guid, query, xmlQuery);
    }

    @Override
    public QueryRequest createQuery(byte[] guid, String query, String xmlQuery, MediaType type) {
        query = I18NConvert.instance().getNorm(query);
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (xmlQuery == null) {
            throw new NullPointerException("null xml query");
        }
        if (query.length() == 0 && xmlQuery.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (xmlQuery.length() != 0 && !xmlQuery.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return this.create(guid, (byte)6, query, xmlQuery, type);
    }

    @Override
    public QueryRequest createProxyQuery(QueryRequest qr, byte[] guid) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + guid.length);
        }
        byte[] payload = qr.getPayload();
        byte[] newPayload = new byte[payload.length];
        System.arraycopy(payload, 0, newPayload, 0, newPayload.length);
        newPayload[0] = SearchSettings.DISABLE_OOB_V2.getBoolean() ? (byte)(newPayload[0] & 0xFFFFFFFB) : (byte)(newPayload[0] | 4);
        GGEP ggep = new GGEP(true);
        ggep.put("SO");
        try {
            newPayload = QueryRequestImpl.patchInGGEP(newPayload, ggep, this.MACCalculatorRepositoryManager);
            return this.createNetworkQuery(guid, qr.getTTL(), qr.getHops(), newPayload, qr.getNetwork());
        }
        catch (BadPacketException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    @Override
    public QueryRequest createDoNotProxyQuery(QueryRequest qr) {
        if (!GUID.isLimeGUID(qr.getGUID())) {
            throw new IllegalArgumentException("query request from different vendor cannot not be unmarked");
        }
        if (!qr.isOriginated()) {
            throw new IllegalArgumentException("query not originated from here");
        }
        return this.createQueryRequest(qr.getGUID(), qr.getTTL(), qr.getMinSpeed(), qr.getQuery(), qr.getRichQueryString(), qr.getQueryUrns(), qr.getQueryKey(), qr.isFirewalledSource(), qr.getNetwork(), qr.desiresOutOfBandReplies(), qr.getFeatureSelector(), true, qr.getMetaMask(), false);
    }

    @Override
    public QueryRequest createQuery(QueryRequest qr, byte ttl) {
        try {
            return this.createNetworkQuery(qr.getGUID(), ttl, qr.getHops(), qr.getPayload(), qr.getNetwork());
        }
        catch (BadPacketException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    @Override
    public QueryRequest unmarkOOBQuery(QueryRequest qr) {
        if (!GUID.isLimeGUID(qr.getGUID())) {
            throw new IllegalArgumentException("query request from different vendor cannot not be unmarked");
        }
        return this.createQueryRequest(qr.getGUID(), qr.getTTL(), qr.getQuery(), qr.getRichQueryString(), qr.getQueryUrns(), qr.getQueryKey(), qr.isFirewalledSource(), qr.getNetwork(), false, qr.getFeatureSelector(), qr.doNotProxy(), qr.getMetaMask());
    }

    @Override
    public QueryRequest createQueryKeyQuery(String query, AddressSecurityToken key) {
        if (query == null) {
            throw new NullPointerException("null query");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (key == null) {
            throw new NullPointerException("null query key");
        }
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, query, "", URN.NO_URN_SET, key, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createQueryKeyQuery(URN sha1, AddressSecurityToken key) {
        if (sha1 == null) {
            throw new NullPointerException("null sha1");
        }
        if (key == null) {
            throw new NullPointerException("null query key");
        }
        UrnSet sha1Set = new UrnSet(sha1);
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, "\\", "", sha1Set, key, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createMulticastQuery(byte[] guid, QueryRequest qr) {
        if (qr == null) {
            throw new NullPointerException("null query");
        }
        byte[] payload = qr.getPayload();
        byte[] newPayload = new byte[payload.length];
        System.arraycopy(payload, 0, newPayload, 0, newPayload.length);
        newPayload[0] = (byte)(newPayload[0] & 0xFFFFFFFB);
        newPayload[0] = (byte)(newPayload[0] | 0x20);
        try {
            return this.createNetworkQuery(guid, (byte)1, qr.getHops(), newPayload, Message.Network.MULTICAST);
        }
        catch (BadPacketException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
    }

    @Override
    public QueryRequest createQueryKeyQuery(QueryRequest qr, AddressSecurityToken key) {
        return this.createQueryRequest(qr.getGUID(), qr.getTTL(), qr.getQuery(), qr.getRichQueryString(), qr.getQueryUrns(), key, qr.isFirewalledSource(), Message.Network.UNKNOWN, qr.desiresOutOfBandReplies(), qr.getFeatureSelector(), false, qr.getMetaMask());
    }

    @Override
    public QueryRequest createBrowseHostQuery() {
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), (byte)1, "    ", "", URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0, false);
    }

    @Override
    public QueryRequest createNonFirewalledQuery(String query, byte ttl) {
        return this.createQueryRequest(QueryRequestImpl.newQueryGUID(false), ttl, query, "", URN.NO_URN_SET, null, false, Message.Network.UNKNOWN, false, 0, false, 0);
    }

    @Override
    public QueryRequest createNetworkQuery(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        return new QueryRequestImpl(guid, ttl, hops, payload, network, this.limeXMLDocumentFactory, this.MACCalculatorRepositoryManager);
    }

    private QueryRequest create(byte[] guid, String query) {
        return this.create(guid, query, "");
    }

    private QueryRequest create(byte[] guid, byte ttl, String query) {
        return this.create(guid, ttl, query, "");
    }

    private QueryRequest create(byte[] guid, String query, String xmlQuery) {
        return this.create(guid, (byte)6, query, xmlQuery);
    }

    private QueryRequest create(byte[] guid, byte ttl, String query, String richQuery) {
        return this.createQueryRequest(guid, ttl, query, richQuery, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, 0);
    }

    private QueryRequest create(byte[] guid, byte ttl, String query, String richQuery, MediaType type) {
        return this.createQueryRequest(guid, ttl, query, richQuery, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, false, 0, false, this.getMetaFlag(type));
    }

    private QueryRequest create(byte[] guid, byte ttl, String query, String richQuery, boolean canReceiveOutOfBandReplies) {
        return this.createQueryRequest(guid, ttl, query, richQuery, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, canReceiveOutOfBandReplies, 0, false, 0);
    }

    private QueryRequest create(byte[] guid, byte ttl, String query, String richQuery, boolean canReceiveOutOfBandReplies, MediaType type) {
        return this.createQueryRequest(guid, ttl, query, richQuery, URN.NO_URN_SET, null, !this.networkManager.acceptedIncomingConnection(), Message.Network.UNKNOWN, canReceiveOutOfBandReplies, 0, false, this.getMetaFlag(type));
    }

    private int getMetaFlag(MediaType type) {
        int metaFlag = 0;
        if (type != null) {
            if (type == MediaType.getAudioMediaType()) {
                metaFlag |= 4;
            } else if (type == MediaType.getVideoMediaType()) {
                metaFlag |= 8;
            } else if (type == MediaType.getImageMediaType()) {
                metaFlag |= 0x20;
            } else if (type == MediaType.getDocumentMediaType()) {
                metaFlag |= 0x10;
            } else if (type == MediaType.getProgramMediaType()) {
                metaFlag = OSUtils.isLinux() || OSUtils.isAnyMac() ? (metaFlag |= 0x80) : (OSUtils.isWindows() ? (metaFlag |= 0x40) : (metaFlag |= 0xC0));
            }
        }
        return metaFlag;
    }

    @Override
    public QueryRequest createQueryRequest(byte[] guid, byte ttl, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector) {
        return this.createQueryRequest(guid, ttl, query, richQuery, queryUrns, addressSecurityToken, isFirewalled, network, canReceiveOutOfBandReplies, featureSelector, false, 0);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] guid, byte ttl, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector, boolean doNotProxy, int metaFlagMask) {
        return this.createQueryRequest(guid, ttl, 0, query, richQuery, queryUrns, addressSecurityToken, isFirewalled, network, canReceiveOutOfBandReplies, featureSelector, doNotProxy, metaFlagMask, true);
    }

    private QueryRequest createQueryRequest(byte[] guid, byte ttl, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector, boolean doNotProxy, int metaFlagMask, boolean normalize) {
        return this.createQueryRequest(guid, ttl, 0, query, richQuery, queryUrns, addressSecurityToken, isFirewalled, network, canReceiveOutOfBandReplies, featureSelector, doNotProxy, metaFlagMask, normalize);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] guid, byte ttl, int minSpeed, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector, boolean doNotProxy, int metaFlagMask) {
        return this.createQueryRequest(guid, ttl, minSpeed, query, richQuery, queryUrns, addressSecurityToken, isFirewalled, network, canReceiveOutOfBandReplies, featureSelector, doNotProxy, metaFlagMask, true);
    }

    @Override
    public QueryRequest createQueryRequest(byte[] guid, byte ttl, int minSpeed, String query, String richQuery, Set<? extends URN> queryUrns, AddressSecurityToken addressSecurityToken, boolean isFirewalled, Message.Network network, boolean canReceiveOutOfBandReplies, int featureSelector, boolean doNotProxy, int metaFlagMask, boolean normalize) {
        return new QueryRequestImpl(guid, ttl, minSpeed, query, richQuery, queryUrns, addressSecurityToken, isFirewalled, network, canReceiveOutOfBandReplies, featureSelector, doNotProxy, metaFlagMask, normalize, this.networkManager.canDoFWT(), this.limeXMLDocumentFactory);
    }
}

