/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.Data;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;
import org.limewire.util.Base32;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class StaticMessages {
    private static final Log LOG = LogFactory.getLog(StaticMessages.class);
    private volatile QueryReply updateReply;
    private volatile QueryReply limeReply;
    private final QueryReplyFactory queryReplyFactory;
    private final Provider<SimppManager> simppManager;

    @Inject
    public StaticMessages(QueryReplyFactory queryReplyFactory, Provider<SimppManager> simppManager) {
        this.queryReplyFactory = queryReplyFactory;
        this.simppManager = simppManager;
    }

    public void initialize() {
        this.reloadMessages();
        this.simppManager.get().addListener(new SimppListener(){

            public void simppUpdated(int newVersion) {
                StaticMessages.this.reloadMessages();
            }
        });
    }

    private void reloadMessages() {
        this.updateReply = this.readUpdateReply();
        this.limeReply = this.createLimeReply();
    }

    private QueryReply readUpdateReply() {
        try {
            return this.createReply(new FileInputStream(new File(CommonUtils.getUserSettingsDir(), "data.ser")));
        }
        catch (FileNotFoundException bad) {
            return null;
        }
    }

    private QueryReply createLimeReply() {
        byte[] reply = Base32.decode(SearchSettings.LIME_SIGNED_RESPONSE.getValue());
        return this.createReply(new ByteArrayInputStream(reply));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryReply createReply(InputStream source) {
        QueryReply queryReply;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            byte[] payload = ((Data)in.readObject()).data;
            queryReply = this.queryReplyFactory.createFromNetwork(new byte[16], (byte)1, (byte)0, payload);
        }
        catch (Throwable t) {
            QueryReply queryReply2;
            try {
                LOG.error("Unable to read serialized data", t);
                queryReply2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close(in);
            return queryReply2;
        }
        IOUtils.close(in);
        return queryReply;
    }

    public QueryReply getUpdateReply() {
        return this.updateReply;
    }

    public QueryReply getLimeReply() {
        return this.limeReply;
    }
}

