/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.util.ByteOrder;

public abstract class AbstractVendorMessage
extends AbstractMessage
implements VendorMessage {
    private final byte[] _vendorID;
    private final int _selector;
    private final int _version;
    private final byte[] _payload;
    private final int _hashCode;

    protected AbstractVendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload) {
        this(vendorIDBytes, selector, version, payload, Message.Network.UNKNOWN);
    }

    protected AbstractVendorMessage(byte[] vendorIDBytes, int selector, int version, byte[] payload, Message.Network network) {
        super((byte)49, (byte)1, 8 + payload.length, network);
        if (vendorIDBytes.length != 4) {
            throw new IllegalArgumentException("wrong vendorID length: " + vendorIDBytes.length);
        }
        if ((selector & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid selector: " + selector);
        }
        if ((version & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("invalid version: " + version);
        }
        this._vendorID = vendorIDBytes;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = AbstractVendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    protected AbstractVendorMessage(byte[] guid, byte ttl, byte hops, byte[] vendorID, int selector, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, (byte)49, ttl, hops, 8 + payload.length, network);
        if (vendorID.length != 4) {
            throw new BadPacketException("Vendor ID Invalid!");
        }
        if ((selector & 0xFFFF0000) != 0) {
            throw new BadPacketException("Selector Invalid!");
        }
        if ((version & 0xFFFF0000) != 0) {
            throw new BadPacketException("Version Invalid!");
        }
        this._vendorID = vendorID;
        this._selector = selector;
        this._version = version;
        this._payload = payload;
        this._hashCode = AbstractVendorMessage.computeHashCode(this._version, this._selector, this._vendorID, this._payload);
    }

    private static int computeHashCode(int version, int selector, byte[] vendorID, byte[] payload) {
        int i;
        int hashCode = 0;
        hashCode += 17 * version;
        hashCode += 17 * selector;
        for (i = 0; i < vendorID.length; ++i) {
            hashCode += 17 * vendorID[i];
        }
        for (i = 0; i < payload.length; ++i) {
            hashCode += 17 * payload[i];
        }
        return hashCode;
    }

    protected byte[] getPayload() {
        return this._payload;
    }

    public int getVersion() {
        return this._version;
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractVendorMessage) {
            AbstractVendorMessage vmp = (AbstractVendorMessage)other;
            return this._selector == vmp._selector && Arrays.equals(this._vendorID, vmp._vendorID) && Arrays.equals(this._payload, vmp._payload);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this._vendorID);
        ByteOrder.short2leb((short)this._selector, out);
        ByteOrder.short2leb((short)this._version, out);
        this.writeVendorPayload(out);
    }

    protected void writeVendorPayload(OutputStream out) throws IOException {
        out.write(this.getPayload());
    }
}

