/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CapabilitiesVM
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    static final byte[] FEATURE_SEARCH_BYTES = new byte[]{87, 72, 65, 84};
    static final byte[] SIMPP_CAPABILITY_BYTES = new byte[]{73, 77, 80, 80};
    static final byte[] LIME_UPDATE_BYTES = new byte[]{76, 77, 85, 80};
    static final byte[] TLS_SUPPORT_BYTES = new byte[]{84, 76, 83, 33};
    public static final int VERSION = 0;
    private final Set<SupportedMessageBlock> _capabilitiesSupported;

    CapabilitiesVM(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_NULL_VENDOR_ID, 10, version, payload, network);
        this._capabilitiesSupported = new HashSet<SupportedMessageBlock>();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getPayload());
            int vectorSize = ByteOrder.ushort2int(ByteOrder.leb2short(bais));
            for (int i = 0; i < vectorSize; ++i) {
                this._capabilitiesSupported.add(new SupportedMessageBlock(bais));
            }
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
    }

    CapabilitiesVM(Set<SupportedMessageBlock> _capabilitiesSupported) {
        super(F_NULL_VENDOR_ID, 10, 0, CapabilitiesVM.derivePayload(_capabilitiesSupported));
        this._capabilitiesSupported = _capabilitiesSupported;
    }

    private static byte[] derivePayload(Set<SupportedMessageBlock> hashSet) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)hashSet.size(), baos);
            for (SupportedMessageBlock currSMP : hashSet) {
                currSMP.encode(baos);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    public int supportsCapability(byte[] capabilityName) {
        for (SupportedMessageBlock currSMP : this._capabilitiesSupported) {
            int version = currSMP.matches(capabilityName);
            if (version <= -1) continue;
            return version;
        }
        return -1;
    }

    public int supportsTLS() {
        return this.supportsCapability(TLS_SUPPORT_BYTES);
    }

    public int supportsFeatureQueries() {
        return this.supportsCapability(FEATURE_SEARCH_BYTES);
    }

    public boolean supportsWhatIsNew() {
        return FeatureSearchData.supportsWhatIsNew(this.supportsCapability(FEATURE_SEARCH_BYTES));
    }

    public int supportsSIMPP() {
        return this.supportsCapability(SIMPP_CAPABILITY_BYTES);
    }

    public int supportsUpdate() {
        return this.supportsCapability(LIME_UPDATE_BYTES);
    }

    public int isActiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.ACTIVE.getCapabilityName());
    }

    public int isPassiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE.getCapabilityName());
    }

    public int isPassiveLeafNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE_LEAF.getCapabilityName());
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CapabilitiesVM) {
            CapabilitiesVM vmp = (CapabilitiesVM)other;
            return ((Object)this._capabilitiesSupported).equals(vmp._capabilitiesSupported);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * ((Object)this._capabilitiesSupported).hashCode();
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    @Override
    public String toString() {
        return "{CapabilitiesVM:" + super.toString() + "; supporting: " + this._capabilitiesSupported + "}";
    }

    public static class SupportedMessageBlock {
        final byte[] _capabilityName;
        final int _version;
        final int _hashCode;

        public String toString() {
            return new String(this._capabilityName) + "/" + this._version;
        }

        public SupportedMessageBlock(byte[] capabilityName, int version) {
            this._capabilityName = capabilityName;
            this._version = version;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public SupportedMessageBlock(InputStream encodedBlock) throws BadPacketException, IOException {
            if (encodedBlock.available() < 6) {
                throw new BadPacketException("invalid block.");
            }
            this._capabilityName = new byte[4];
            encodedBlock.read(this._capabilityName, 0, this._capabilityName.length);
            this._version = ByteOrder.ushort2int(ByteOrder.leb2short(encodedBlock));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public void encode(OutputStream out) throws IOException {
            out.write(this._capabilityName);
            ByteOrder.short2leb((short)this._version, out);
        }

        public int matches(byte[] capabilityName) {
            if (Arrays.equals(this._capabilityName, capabilityName)) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object other) {
            if (other instanceof SupportedMessageBlock) {
                SupportedMessageBlock vmp = (SupportedMessageBlock)other;
                return this._version == vmp._version && Arrays.equals(this._capabilityName, vmp._capabilityName);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] capabilityName, int version) {
            int hashCode = 0;
            hashCode += 37 * version;
            for (int i = 0; i < capabilityName.length; ++i) {
                hashCode += 37 * capabilityName[i];
            }
            return hashCode;
        }
    }
}

