/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.version.UpdateHandler;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CapabilitiesVMFactoryImpl
implements CapabilitiesVMFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<SimppManager> simppManager;
    private final Provider<UpdateHandler> updateHandler;
    private volatile CapabilitiesVM currentCapabilities;

    @Inject
    public CapabilitiesVMFactoryImpl(Provider<DHTManager> dhtManager, Provider<SimppManager> simppManager, Provider<UpdateHandler> updateHandler) {
        this.dhtManager = dhtManager;
        this.simppManager = simppManager;
        this.updateHandler = updateHandler;
    }

    @Override
    public CapabilitiesVM getCapabilitiesVM() {
        if (this.currentCapabilities == null) {
            this.currentCapabilities = new CapabilitiesVM(this.getSupportedMessages());
        }
        return this.currentCapabilities;
    }

    @Override
    public void updateCapabilities() {
        this.currentCapabilities = new CapabilitiesVM(this.getSupportedMessages());
    }

    protected Set<CapabilitiesVM.SupportedMessageBlock> getSupportedMessages() {
        HashSet<CapabilitiesVM.SupportedMessageBlock> supported = new HashSet<CapabilitiesVM.SupportedMessageBlock>();
        CapabilitiesVM.SupportedMessageBlock smb = null;
        smb = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.FEATURE_SEARCH_BYTES, 1);
        supported.add(smb);
        smb = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.SIMPP_CAPABILITY_BYTES, this.simppManager.get().getVersion());
        supported.add(smb);
        smb = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.LIME_UPDATE_BYTES, this.updateHandler.get().getLatestId());
        supported.add(smb);
        if (this.dhtManager.get().isMemberOfDHT()) {
            DHTManager.DHTMode mode = this.dhtManager.get().getDHTMode();
            assert (mode != null);
            smb = new CapabilitiesVM.SupportedMessageBlock(mode.getCapabilityName(), this.dhtManager.get().getVersion().shortValue());
            supported.add(smb);
        }
        if (SSLSettings.isIncomingTLSEnabled()) {
            smb = new CapabilitiesVM.SupportedMessageBlock(CapabilitiesVM.TLS_SUPPORT_BYTES, 1);
            supported.add(smb);
        }
        return supported;
    }
}

