/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.RoutableGGEPMessage;
import java.net.UnknownHostException;
import org.limewire.io.IPPortCombo;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionRequestImpl
extends RoutableGGEPMessage
implements InspectionRequest {
    static final String INSPECTION_KEY = "I";
    static final String TIMESTAMP_KEY = "T";
    static final String ENCODING_KEY = "E";
    private static final int DEFAULT_INTERVAL = 500;
    private final String[] requested;
    private final boolean timestamp;
    private final boolean encoding;
    private final int sendInterval;

    public InspectionRequestImpl(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 30, version, payload, network);
        String requested;
        try {
            requested = this.ggep.getString(INSPECTION_KEY);
            this.timestamp = this.ggep.hasKey(TIMESTAMP_KEY);
            this.encoding = this.ggep.hasKey(ENCODING_KEY);
            int interval = 500;
            try {
                interval = this.ggep.getInt(ENCODING_KEY);
            }
            catch (BadGGEPPropertyException noTime) {
                // empty catch block
            }
            this.sendInterval = interval;
        }
        catch (BadGGEPPropertyException bad) {
            throw new BadPacketException();
        }
        this.requested = requested.split(";");
    }

    InspectionRequestImpl(RoutableGGEPMessage.GGEPSigner signer, String ... requested) {
        this(new GUID(), signer, false, false, 500, 1L, null, null, requested);
    }

    public InspectionRequestImpl(GUID g, RoutableGGEPMessage.GGEPSigner signer, boolean timestamp, boolean encoding, int sendInterval, long version, IpPort returnAddr, IpPort destAddress, String ... requested) {
        super(F_LIME_VENDOR_ID, 30, 1, signer, InspectionRequestImpl.deriveGGEP(timestamp, encoding, sendInterval, version, returnAddr, destAddress, requested));
        this.setGUID(g);
        this.requested = requested;
        this.timestamp = timestamp;
        this.encoding = encoding;
        this.sendInterval = sendInterval;
    }

    @Override
    public String[] getRequestedFields() {
        return this.requested;
    }

    @Override
    public boolean requestsTimeStamp() {
        return this.timestamp;
    }

    @Override
    public boolean supportsEncoding() {
        return this.encoding;
    }

    @Override
    public void setGUID(GUID g) {
        super.setGUID(g);
    }

    private static GGEP deriveGGEP(boolean timestamp, boolean encoding, int sendInterval, long version, IpPort returnAddr, IpPort destAddr, String ... requested) {
        StringBuilder b = new StringBuilder();
        for (String r : requested) {
            b.append(r).append(";");
        }
        String ret = b.charAt(b.length() - 1) == ';' ? b.substring(0, b.length() - 1) : b.toString();
        GGEP g = new GGEP();
        g.putCompressed(INSPECTION_KEY, ret.getBytes());
        if (timestamp) {
            g.put(TIMESTAMP_KEY);
        }
        if (encoding) {
            g.put(ENCODING_KEY, sendInterval);
        }
        if (returnAddr != null) {
            try {
                IPPortCombo ipc = new IPPortCombo(returnAddr.getAddress(), returnAddr.getPort());
                g.put("RA", ipc.toBytes());
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
        }
        if (destAddr != null) {
            try {
                IPPortCombo ipc = new IPPortCombo(destAddr.getAddress(), destAddr.getPort());
                g.put("TO", ipc.toBytes());
            }
            catch (UnknownHostException ignore) {
                // empty catch block
            }
        }
        if (version >= 0L) {
            g.put("V", version);
        }
        return g;
    }

    @Override
    public int getVersion() {
        return super.getVersion();
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return InspectionRequest.class;
    }

    @Override
    public int getSendInterval() {
        return this.sendInterval;
    }
}

