/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import com.limegroup.gnutella.metadata.audio.reader.MP3MetaData;
import com.limegroup.gnutella.metadata.audio.reader.OGGMetaData;
import com.limegroup.gnutella.metadata.audio.reader.WMAMetaData;
import com.limegroup.gnutella.metadata.audio.writer.FlacDataEditor;
import com.limegroup.gnutella.metadata.audio.writer.M4ADataEditor;
import com.limegroup.gnutella.metadata.audio.writer.MP3DataEditor;
import com.limegroup.gnutella.metadata.audio.writer.OGGDataEditor;
import com.limegroup.gnutella.metadata.video.reader.MOVMetaData;
import com.limegroup.gnutella.metadata.video.reader.MPEGMetaData;
import com.limegroup.gnutella.metadata.video.reader.OGMMetaData;
import com.limegroup.gnutella.metadata.video.reader.RIFFMetaData;
import com.limegroup.gnutella.metadata.video.reader.WMVMetaData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaDataFactoryImpl
implements MetaDataFactory {
    private static final Log LOG = LogFactory.getLog(MetaDataFactory.class);

    public MetaWriter getEditorForFile(String name) {
        if (LimeXMLUtils.isSupportedAudioFormat(name)) {
            return this.getAudioEditorForFile(name);
        }
        return null;
    }

    public MetaReader parse(File f) throws IOException {
        try {
            if (LimeXMLUtils.isSupportedAudioFormat(f)) {
                return this.parseAudioFile(f);
            }
            if (LimeXMLUtils.isSupportedVideoFormat(f)) {
                return this.parseVideoMetaData(f);
            }
            if (LimeXMLUtils.isSupportedMultipleFormat(f)) {
                return this.parseMultipleFormat(f);
            }
        }
        catch (OutOfMemoryError e) {
            LOG.warn("Ran out of memory while parsing.", e);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return null;
    }

    private MetaReader parseMultipleFormat(File f) throws IOException {
        if (LimeXMLUtils.isASFFile(f)) {
            ASFParser p = new ASFParser(f);
            if (p.hasVideo()) {
                return new WMVMetaData(p);
            }
            if (p.hasAudio()) {
                return new WMAMetaData(p);
            }
        }
        return null;
    }

    private MetaWriter getAudioEditorForFile(String name) {
        if (LimeXMLUtils.isMP3File(name)) {
            return new MP3DataEditor();
        }
        if (LimeXMLUtils.isOGGFile(name)) {
            return new OGGDataEditor();
        }
        if (LimeXMLUtils.isM4AFile(name)) {
            return new M4ADataEditor();
        }
        if (LimeXMLUtils.isFLACFile(name)) {
            return new FlacDataEditor();
        }
        return null;
    }

    private MetaReader parseAudioFile(File f) throws IOException, IllegalArgumentException {
        if (LimeXMLUtils.isMP3File(f)) {
            return new MP3MetaData(f);
        }
        if (LimeXMLUtils.isOGGFile(f)) {
            return new OGGMetaData(f);
        }
        if (LimeXMLUtils.isFLACFile(f)) {
            return new AudioDataReader(f);
        }
        if (LimeXMLUtils.isM4AFile(f)) {
            return new AudioDataReader(f);
        }
        if (LimeXMLUtils.isWMAFile(f)) {
            return new WMAMetaData(f);
        }
        return null;
    }

    private MetaReader parseVideoMetaData(File file) throws IOException {
        if (LimeXMLUtils.isRIFFFile(file)) {
            return new RIFFMetaData(file);
        }
        if (LimeXMLUtils.isOGMFile(file)) {
            return new OGMMetaData(file);
        }
        if (LimeXMLUtils.isWMVFile(file)) {
            return new WMVMetaData(file);
        }
        if (LimeXMLUtils.isMPEGFile(file)) {
            return new MPEGMetaData(file);
        }
        if (LimeXMLUtils.isQuickTimeFile(file)) {
            return new MOVMetaData(file);
        }
        return null;
    }
}

