/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;

public class MetaDataWriter {
    private final String fileName;
    private final MetaWriter editor;
    protected LimeXMLDocument correctDocument = null;

    public MetaDataWriter(String fileName, MetaDataFactory metaDataFactory) {
        this.fileName = fileName;
        this.editor = metaDataFactory.getEditorForFile(fileName);
    }

    public boolean needsToUpdate(MetaData data) {
        if (this.editor.getMetaData() == null) {
            return false;
        }
        if (data == null) {
            return true;
        }
        return !this.editor.getMetaData().equals(data);
    }

    public LimeXMLReplyCollection.MetaDataState commitMetaData() {
        return this.editor.commitMetaData(this.fileName);
    }

    public void populate(LimeXMLDocument doc) {
        if (this.editor == null) {
            throw new NullPointerException("Editor not created");
        }
        this.correctDocument = doc;
        this.editor.populate(doc);
    }

    public LimeXMLDocument getCorrectDocument() {
        return this.correctDocument;
    }

    public MetaWriter getEditor() {
        return this.editor;
    }
}

