/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioMetaData
implements MetaData {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String comment;
    private String track;
    private String genre;
    private int bitrate = -1;
    private int length = -1;
    private short totalTracks = (short)-1;
    private short disk = (short)-1;
    private short totalDisks = (short)-1;
    private String license;
    private String licensetype;
    private String channels;
    private int sampleRate = -1;
    private boolean isVBR = false;

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/audio.xsd";
    }

    @Override
    public void populate(LimeXMLDocument doc) {
        this.title = doc.getValue("audios__audio__title__") == null ? "" : doc.getValue("audios__audio__title__");
        this.artist = doc.getValue("audios__audio__artist__") == null ? "" : doc.getValue("audios__audio__artist__");
        this.album = doc.getValue("audios__audio__album__") == null ? "" : doc.getValue("audios__audio__album__");
        this.year = doc.getValue("audios__audio__year__") == null ? "" : doc.getValue("audios__audio__year__");
        this.track = doc.getValue("audios__audio__track__") == null ? "" : doc.getValue("audios__audio__track__");
        this.comment = doc.getValue("audios__audio__comments__") == null ? "" : doc.getValue("audios__audio__comments__");
        this.genre = doc.getValue("audios__audio__genre__") == null ? "" : doc.getValue("audios__audio__genre__");
        this.license = doc.getValue("audios__audio__license__") == null ? "" : doc.getValue("audios__audio__license__");
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        ArrayList<NameValue<String>> list = new ArrayList<NameValue<String>>();
        this.add(list, this.title, "audios__audio__title__");
        this.add(list, this.artist, "audios__audio__artist__");
        this.add(list, this.album, "audios__audio__album__");
        this.add(list, this.year, "audios__audio__year__");
        this.add(list, this.comment, "audios__audio__comments__");
        this.add(list, this.track, "audios__audio__track__");
        this.add(list, this.genre, "audios__audio__genre__");
        this.add(list, this.bitrate, "audios__audio__bitrate__");
        this.add(list, this.length, "audios__audio__seconds__");
        this.add(list, this.license, "audios__audio__license__");
        this.add(list, this.licensetype, "audios__audio__licensetype__");
        return list;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTrack() {
        return this.track;
    }

    public short getTotalTracks() {
        return this.totalTracks;
    }

    public short getDisk() {
        return this.disk;
    }

    public short getTotalDisks() {
        return this.totalDisks;
    }

    public String getGenre() {
        return this.genre;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getLength() {
        return this.length;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseType() {
        return this.licensetype;
    }

    public String getNumChannels() {
        return this.channels;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isVBR() {
        return this.isVBR;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTrack(String track) {
        this.track = track;
    }

    public void setTotalTracks(short total) {
        this.totalTracks = total;
    }

    public void setDisk(short disk) {
        this.disk = disk;
    }

    public void setTotalDisks(short total) {
        this.totalDisks = total;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setLicenseType(String licensetype) {
        this.licensetype = licensetype;
    }

    public void setNumChannels(String channels) {
        this.channels = channels;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void setVBR(boolean isVBR) {
        this.isVBR = isVBR;
    }

    private void add(List<NameValue<String>> list, String value, String key) {
        if (this.isValid(value)) {
            list.add(new NameValue<String>(key, value.trim()));
        }
    }

    private void add(List<NameValue<String>> list, int value, String key) {
        if (this.isValid(value)) {
            list.add(new NameValue<String>(key, "" + value));
        }
    }

    private boolean isValid(String s) {
        return s != null && !s.trim().equals("");
    }

    private boolean isValid(int i) {
        return i >= 0;
    }

    public static boolean isCorrupted(LimeXMLDocument doc) {
        if (!"http://www.limewire.com/schemas/audio.xsd".equals(doc.getSchemaURI())) {
            return false;
        }
        for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!name.equals("audios__audio__album__") && !name.equals("audios__audio__artist__") || value.length() != 30 || value.charAt(29) == ' ' || value.charAt(28) != ' ') continue;
            return true;
        }
        return false;
    }

    public static LimeXMLDocument fixCorruption(LimeXMLDocument oldDoc, LimeXMLDocumentFactory limeXMLDocumentFactory) {
        ArrayList<NameValue<String>> info = new ArrayList<NameValue<String>>(oldDoc.getNumFields());
        for (Map.Entry<String, String> entry : oldDoc.getNameValueSet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if ((name.equals("audios__audio__album__") || name.equals("audios__audio__artist__")) && value.length() == 30 && value.charAt(29) != ' ' && value.charAt(28) == ' ') {
                value = value.substring(0, 29).trim();
            }
            info.add(new NameValue<String>(name, value));
        }
        return limeXMLDocumentFactory.createLimeXMLDocument(info, oldDoc.getSchemaURI());
    }

    public static boolean isNonLimeAudioField(String fieldName) {
        return !fieldName.equals("audios__audio__track__") && !fieldName.equals("audios__audio__artist__") && !fieldName.equals("audios__audio__album__") && !fieldName.equals("audios__audio__title__") && !fieldName.equals("audios__audio__genre__") && !fieldName.equals("audios__audio__year__") && !fieldName.equals("audios__audio__comments__") && !fieldName.equals("audios__audio__bitrate__") && !fieldName.equals("audios__audio__seconds__") && !fieldName.equals("audios__audio__license__") && !fieldName.equals("audios__audio__price__") && !fieldName.equals("audios__audio__licensetype__");
    }
}

