/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;

public class MP3MetaData
extends AudioDataReader {
    static final String LICENSE_ID = "TCOP";
    static final String PRIV_ID = "PRIV";

    public MP3MetaData(File f) throws IOException, IllegalArgumentException {
        super(f);
    }

    protected void readTag(AudioFile audioFile, Tag tag) {
        if (tag != null) {
            this.audioData.setTitle(tag.getFirstTitle());
            this.audioData.setArtist(tag.getFirstArtist());
            this.audioData.setAlbum(tag.getFirstAlbum());
            this.audioData.setYear(tag.getFirstYear());
            this.audioData.setComment(tag.getFirstComment());
            this.audioData.setGenre(tag.getFirstGenre());
            try {
                this.audioData.setTrack(tag.getFirstTrack());
            }
            catch (UnsupportedOperationException e) {
                // empty catch block
            }
            if (!(tag instanceof ID3v1Tag)) {
                this.audioData.setLicense(tag.getFirst(LICENSE_ID));
                MP3File mp3File = (MP3File)audioFile;
                this.audioData.setGenre(this.parseGenre(tag.getFirstGenre()));
                AbstractID3v2Tag vTag = mp3File.getID3v2Tag();
                if (vTag != null) {
                    List<TagField> license = vTag.get(PRIV_ID);
                    List<TagField> priv = vTag.get(PRIV_ID);
                    for (TagField t : license) {
                        this.checkLWS(((Object)t).toString());
                    }
                    for (TagField t : priv) {
                        this.checkLWS(((Object)t).toString());
                        try {
                            this.isPRIVCheck(t.getRawContent());
                        }
                        catch (UnsupportedEncodingException e) {}
                    }
                    AbstractID3v2Frame frame = vTag.getFirstField(LICENSE_ID);
                    if (frame != null && !frame.isEmpty() && frame.getBody() instanceof AbstractFrameBodyTextInfo) {
                        this.audioData.setLicense(((AbstractFrameBodyTextInfo)frame.getBody()).getText());
                    }
                }
            }
        }
    }

    private void isPRIVCheck(byte[] contentBytes) {
        try {
            String content = new String(contentBytes, "UTF-8");
            this.checkLWS(content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void checkLWS(String content) {
        if (!(this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED") || content.indexOf("NOT CLEARED") == -1)) {
            this.audioData.setLicenseType("NOT CLEARED");
        }
    }

    private String parseGenre(String genre) {
        if (genre == null || genre.length() <= 0) {
            return genre;
        }
        String cleanGenre = genre;
        if (genre.charAt(0) == '(') {
            int startIndex = 0;
            for (int i = 0; i < genre.length(); ++i) {
                if (genre.charAt(i) != ')') continue;
                startIndex = i + 1;
            }
            cleanGenre = genre.substring(startIndex);
        }
        return cleanGenre;
    }
}

