/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMAMetaData
implements MetaReader {
    protected final AudioMetaData audioData = new AudioMetaData();

    public WMAMetaData(File f) throws IOException {
        this.parseFile(f);
    }

    public WMAMetaData(ASFParser p) throws IOException {
        this.set(p);
    }

    private void parseFile(File f) throws IOException {
        ASFParser data = new ASFParser(f);
        this.set(data);
    }

    private void set(ASFParser data) throws IOException {
        if (data.hasVideo()) {
            throw new IOException("use WMV instead!");
        }
        if (!data.hasAudio()) {
            throw new IOException("no audio data!");
        }
        this.audioData.setTitle(data.getTitle());
        this.audioData.setAlbum(data.getAlbum());
        this.audioData.setArtist(data.getArtist());
        this.audioData.setYear(data.getYear());
        this.audioData.setComment(data.getComment());
        this.audioData.setTrack(String.valueOf(data.getTrack()));
        this.audioData.setBitrate(data.getBitrate());
        this.audioData.setLength(data.getLength());
        this.audioData.setGenre(data.getGenre());
        this.audioData.setLicense(data.getCopyright());
        if (data.getLicenseInfo() != null) {
            this.audioData.setLicenseType(data.getLicenseInfo());
        }
    }

    @Override
    public MetaData getMetaData() {
        return this.audioData;
    }

    @Override
    public String getSchemaURI() {
        return "http://www.limewire.com/schemas/audio.xsd";
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.audioData.toNameValueList();
    }
}

