/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.writer;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import java.io.File;
import java.io.IOException;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.limewire.util.FileUtils;

public abstract class AudioDataEditor
implements MetaWriter {
    protected final AudioMetaData audioData = new AudioMetaData();

    public MetaData getMetaData() {
        return this.audioData;
    }

    public void populate(LimeXMLDocument doc) {
        this.audioData.populate(doc);
    }

    protected Tag updateTag(Tag tag, AudioFile audioFile) throws FieldDataInvalidException {
        tag.setAlbum(this.audioData.getAlbum());
        tag.setArtist(this.audioData.getArtist());
        tag.setComment(this.audioData.getComment());
        tag.setGenre(this.audioData.getGenre());
        tag.setTitle(this.audioData.getTitle());
        tag.setYear(this.audioData.getYear());
        tag.setTrack(this.audioData.getTrack());
        return tag;
    }

    protected abstract boolean isValidFileType(String var1);

    protected abstract Tag createTag(AudioFile var1);

    public LimeXMLReplyCollection.MetaDataState commitMetaData(String fileName) {
        if (!this.isValidFileType(fileName)) {
            return LimeXMLReplyCollection.MetaDataState.INCORRECT_FILETYPE;
        }
        File f = new File(fileName);
        FileUtils.setWriteable(f);
        try {
            AudioFile audioFile = AudioFileIO.read(f);
            Tag audioTag = this.createTag(audioFile);
            audioTag = this.updateTag(audioTag, audioFile);
            audioFile.setTag(audioTag);
            audioFile.commit();
        }
        catch (CannotReadException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (IOException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (TagException e) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (ReadOnlyFileException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (InvalidAudioFrameException e) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (CannotWriteException e) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        return LimeXMLReplyCollection.MetaDataState.NORMAL;
    }
}

