/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IOUtils;

public class MPEGMetaData
extends VideoDataReader {
    private static final Log LOG = LogFactory.getLog(MPEGMetaData.class);
    private static final int PACK_START_CODE = 442;
    private static final int SEQ_START_CODE = 435;
    private static final int MAX_FORWARD_READ_LENGTH = 50000;
    private static final int MAX_BACKWARD_READ_LENGTH = 3000000;

    public MPEGMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File f) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "r");
            this.parseMPEG(raf);
        }
        catch (Throwable throwable) {
            IOUtils.close(raf);
            throw throwable;
        }
        IOUtils.close(raf);
    }

    private void parseMPEG(RandomAccessFile raf) throws IOException {
        boolean firstGOP = false;
        boolean firstSEQ = false;
        boolean lastGOP = false;
        long initialHMS = -1L;
        do {
            byte[] b;
            LOG.debug("Advancing to next code...");
            this.nextStartCode(raf);
            int code = raf.readInt();
            if (code == 442 && !firstGOP) {
                LOG.debug("Found GOP code");
                firstGOP = true;
                b = new byte[6];
                raf.readFully(b);
                if ((b[0] & 0xF0) == 32) {
                    initialHMS = this.getMPEGHMS(b);
                    continue;
                }
                if ((b[0] & 0xC0) != 64) continue;
                initialHMS = this.getMPEG2HMS(b);
                continue;
            }
            if (code != 435 || firstSEQ) continue;
            LOG.debug("Found SEQ code");
            firstSEQ = true;
            b = new byte[3];
            raf.readFully(b);
            this.videoData.setWidth((b[0] & 0xFF) << 4 | b[1] & 0xF0);
            this.videoData.setHeight((b[1] & 0xF) << 8 | b[2] & 0xFF);
        } while (!firstSEQ || !firstGOP);
        if (initialHMS != -1L) {
            raf.seek(raf.length());
            while (true) {
                LOG.debug("Rewinding to prior code...");
                this.previousStartCode(raf);
                if (raf.readInt() == 442) break;
                raf.seek(raf.getFilePointer() - 4L);
            }
            LOG.debug("Found GOP code");
            lastGOP = true;
            if (lastGOP) {
                byte[] b = new byte[6];
                long lastHMS = -1L;
                raf.readFully(b);
                if ((b[0] & 0xF0) == 32) {
                    lastHMS = this.getMPEGHMS(b);
                } else if ((b[0] & 0xC0) == 64) {
                    lastHMS = this.getMPEG2HMS(b);
                }
                if (lastHMS != -1L) {
                    this.videoData.setLength((int)(lastHMS - initialHMS));
                }
            }
        }
    }

    private void nextStartCode(RandomAccessFile raf) throws IOException {
        int available;
        byte[] b = new byte[1024];
        for (int i = 0; i < 50000; i += available) {
            available = raf.read(b);
            if (available > 0) {
                i += available;
                for (int offset = 0; offset < available - 2; ++offset) {
                    if (b[offset] != 0 || b[offset + 1] != 0 || b[offset + 2] != 1) continue;
                    raf.seek(raf.getFilePointer() - (long)(available - offset));
                    return;
                }
                continue;
            }
            throw new IOException("no start code");
        }
        throw new IOException("no start code");
    }

    private void previousStartCode(RandomAccessFile raf) throws IOException {
        byte[] b = new byte[8024];
        for (int i = 0; i < 3000000; i += b.length) {
            long fp = raf.getFilePointer() - (long)b.length;
            if (fp < 0L) {
                if (fp <= (long)b.length) break;
                fp = 0L;
            }
            raf.seek(fp);
            raf.readFully(b);
            for (int offset = b.length - 1; offset > 1; --offset) {
                if (b[offset - 2] != 0 || b[offset - 1] != 0 || b[offset] != 1) continue;
                raf.seek(raf.getFilePointer() - (long)(b.length - offset) - 2L);
                return;
            }
            raf.seek(raf.getFilePointer() - (long)b.length);
        }
        throw new IOException("no prior start code");
    }

    protected long getMPEGHMS(byte[] b) {
        long low4Bytes = ((b[0] & 0xFF) >> 1 & 3) << 30 | (b[1] & 0xFF) << 22 | (b[2] & 0xFF) >> 1 << 15 | (b[3] & 0xFF) << 7 | (b[4] & 0xFF) >> 1;
        return low4Bytes / 90000L;
    }

    protected long getMPEG2HMS(byte[] b) {
        long low4Bytes = (b[0] & 0x18) >> 3 << 30 | (b[0] & 3) << 28 | (b[1] & 0xFF) << 20 | (b[2] & 0xF8) >> 1 << 15 | (b[2] & 3) << 13 | (b[3] & 0xFF) << 5 | (b[4] & 0xFF) >> 3;
        int sys_clock_extension = (b[4] & 3) << 7 | (b[5] & 0xFF) >> 1;
        if (sys_clock_extension == 0) {
            return low4Bytes / 90000L;
        }
        return -1L;
    }
}

