/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.limewire.io.IOUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OGMMetaData
extends VideoDataReader {
    public static final String TITLE_TAG = "title";
    public static final String COMMENT_TAG = "comment";
    public static final String LICENSE_TAG = "license";
    private static final String DATE_TAG = "date";
    private static final String LANGUAGE_TAG = "language";

    public OGMMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseFile(File file) throws IOException {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(is);
            Set<String> set = this.readMetaData(dis);
            this.parseMetaData(set);
        }
        catch (Throwable throwable) {
            IOUtils.close(is);
            throw throwable;
        }
        IOUtils.close(is);
    }

    private Set<String> readMetaData(DataInputStream dis) throws IOException {
        int pageSize;
        HashSet<String> set = new HashSet<String>();
        boolean shouldStop = false;
        while (!(shouldStop = this.parseCommentBlock(pageSize = this.readHeader(dis), dis, set))) {
        }
        return set;
    }

    private int readHeader(DataInputStream dis) throws IOException {
        if (dis.readByte() != 79) {
            throw new IOException("not an ogg file");
        }
        if (dis.readByte() != 103) {
            throw new IOException("not an ogg file");
        }
        if (dis.readByte() != 103) {
            throw new IOException("not an ogg file");
        }
        if (dis.readByte() != 83) {
            throw new IOException("not an ogg file");
        }
        IOUtils.ensureSkip(dis, 22L);
        int segments = dis.readUnsignedByte();
        int size = 0;
        for (int i = 0; i < segments; ++i) {
            size += dis.readUnsignedByte();
        }
        return size;
    }

    private boolean parseCommentBlock(int pageSize, DataInputStream dis, Set<String> comments) throws IOException {
        byte type = dis.readByte();
        --pageSize;
        if ((type & 1) != 1) {
            IOUtils.ensureSkip(dis, pageSize);
            return true;
        }
        if (type != 3) {
            IOUtils.ensureSkip(dis, pageSize);
            return false;
        }
        byte[] vorbis = new byte[6];
        dis.readFully(vorbis);
        pageSize -= 6;
        if (vorbis[0] != 118 || vorbis[1] != 111 || vorbis[2] != 114 || vorbis[3] != 98 || vorbis[4] != 105 || vorbis[5] != 115) {
            IOUtils.ensureSkip(dis, pageSize);
            return true;
        }
        byte[] dword = new byte[4];
        dis.readFully(dword);
        int vendorStringSize = ByteOrder.leb2int(dword, 0);
        byte[] vendorString = new byte[vendorStringSize];
        dis.readFully(vendorString);
        dis.readFully(dword);
        int numComments = ByteOrder.leb2int(dword, 0);
        for (int i = 0; i < numComments; ++i) {
            dis.readFully(dword);
            int commentSize = ByteOrder.leb2int(dword, 0);
            byte[] comment = new byte[commentSize];
            dis.readFully(comment);
            comments.add(new String(comment, "UTF-8"));
        }
        return (dis.readByte() & 1) != 1;
    }

    private void parseMetaData(Set<String> data) {
        for (String comment : data) {
            int index = comment.indexOf(61);
            if (index <= 0) continue;
            String key = comment.substring(0, index);
            String value = comment.substring(index + 1);
            if (key.equalsIgnoreCase(COMMENT_TAG)) {
                if (this.videoData.getComment() != null) {
                    this.videoData.setComment(this.videoData.getComment() + "\n" + value);
                    continue;
                }
                this.videoData.setComment(value);
                continue;
            }
            if (key.equalsIgnoreCase(LANGUAGE_TAG)) {
                if (this.videoData.getLanguage() != null) {
                    this.videoData.setLanguage(this.videoData.getLanguage() + ";" + value);
                    continue;
                }
                this.videoData.setLanguage(value);
                continue;
            }
            if (key.equalsIgnoreCase(LICENSE_TAG)) {
                this.videoData.setLicense(value);
                continue;
            }
            if (key.equalsIgnoreCase(TITLE_TAG)) {
                this.videoData.setTitle(value);
                continue;
            }
            if (!key.equalsIgnoreCase(DATE_TAG)) continue;
            this.videoData.setYear(value);
        }
    }
}

