/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.reader.ASFParser;
import com.limegroup.gnutella.metadata.video.VideoMetaData;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMVMetaData
implements MetaReader {
    private final VideoMetaData videoData = new VideoMetaData();

    public WMVMetaData(File f) throws IOException {
        this.parseFile(f);
    }

    public WMVMetaData(ASFParser p) throws IOException {
        this.set(p);
    }

    protected void parseFile(File f) throws IOException {
        ASFParser data = new ASFParser(f);
        this.set(data);
    }

    private void set(ASFParser data) throws IOException {
        if (!data.hasVideo()) {
            throw new IOException("no video data!");
        }
        this.videoData.setTitle(data.getTitle());
        this.videoData.setYear(data.getYear());
        this.videoData.setComment(data.getComment());
        this.videoData.setLength(data.getLength());
        this.videoData.setWidth(data.getWidth());
        this.videoData.setHeight(data.getHeight());
        if (data.getLicenseInfo() != null) {
            this.videoData.setLicenseType(data.getLicenseInfo());
        }
    }

    @Override
    public MetaData getMetaData() {
        return this.videoData;
    }

    @Override
    public String getSchemaURI() {
        return this.videoData.getSchemaURI();
    }

    @Override
    public List<NameValue<String>> toNameValueList() {
        return this.videoData.toNameValueList();
    }
}

