/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteOrder;

public class PatchTableMessage
extends RouteTableMessage {
    private short sequenceNumber;
    private short sequenceSize;
    private byte compressor;
    private byte entryBits;
    private byte[] data;
    public static final byte COMPRESSOR_NONE = 0;
    public static final byte COMPRESSOR_DEFLATE = 1;

    public PatchTableMessage(short sequenceNumber, short sequenceSize, byte compressor, byte entryBits, byte[] dataSrc, int dataSrcStart, int dataSrcStop) {
        super((byte)1, 5 + (dataSrcStop - dataSrcStart), (byte)1);
        this.sequenceNumber = sequenceNumber;
        this.sequenceSize = sequenceSize;
        this.compressor = compressor;
        this.entryBits = entryBits;
        this.data = new byte[dataSrcStop - dataSrcStart];
        System.arraycopy(dataSrc, dataSrcStart, this.data, 0, this.data.length);
    }

    protected void writePayloadData(OutputStream out) throws IOException {
        byte[] buf = new byte[4 + this.data.length];
        buf[0] = (byte)this.sequenceNumber;
        buf[1] = (byte)this.sequenceSize;
        buf[2] = this.compressor;
        buf[3] = this.entryBits;
        System.arraycopy(this.data, 0, buf, 4, this.data.length);
        out.write(buf);
    }

    protected PatchTableMessage(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, payload.length, (byte)1, network);
        assert (payload[0] == 1);
        this.sequenceNumber = (short)ByteOrder.ubyte2int(payload[1]);
        this.sequenceSize = (short)ByteOrder.ubyte2int(payload[2]);
        if (this.sequenceNumber < 1 || this.sequenceSize < 1 || this.sequenceNumber > this.sequenceSize) {
            throw new BadPacketException("Bad sequence/size: " + this.sequenceNumber + "/" + this.sequenceSize);
        }
        this.compressor = payload[3];
        if (this.compressor != 0 && this.compressor != 1) {
            throw new BadPacketException("Bad compressor: " + this.compressor);
        }
        this.entryBits = payload[4];
        if (this.entryBits < 0) {
            throw new BadPacketException("Negative entryBits: " + this.entryBits);
        }
        this.data = new byte[payload.length - 5];
        System.arraycopy(payload, 5, this.data, 0, this.data.length);
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSequenceSize() {
        return this.sequenceSize;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public byte getEntryBits() {
        return this.entryBits;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{PATCH, Sequence: " + this.getSequenceNumber() + "/" + this.getSequenceSize() + ", Bits: " + this.entryBits + ", Compr: " + this.getCompressor() + ", [");
        buf.append("<" + this.data.length + " bytes>");
        buf.append("]");
        return buf.toString();
    }
}

