/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.search.HostDataFactory;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.util.ByteOrder;

@Singleton
public class HostDataFactoryImpl
implements HostDataFactory {
    private final NetworkManager networkManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HostDataFactoryImpl(NetworkManager networkManager, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public HostData createHostData(QueryReply reply) {
        byte[] clientGuid = reply.getClientGUID();
        byte[] messageGuid = reply.getGUID();
        String ip = reply.getIP();
        int port = reply.getPort();
        boolean firewalled = true;
        boolean busy = true;
        boolean browseHostEnabled = false;
        boolean chatEnabled = false;
        boolean measuredSpeed = false;
        boolean multicast = false;
        String vendor = "";
        try {
            firewalled = reply.getNeedsPush() || this.networkInstanceUtils.isPrivateAddress(ip);
        }
        catch (BadPacketException e) {
            firewalled = true;
        }
        try {
            measuredSpeed = reply.getIsMeasuredSpeed();
        }
        catch (BadPacketException e) {
            measuredSpeed = false;
        }
        try {
            busy = reply.getIsBusy();
        }
        catch (BadPacketException bad) {
            busy = true;
        }
        try {
            vendor = reply.getVendor();
        }
        catch (BadPacketException bad) {
            // empty catch block
        }
        browseHostEnabled = reply.getSupportsBrowseHost();
        chatEnabled = reply.getSupportsChat() && !firewalled;
        multicast = reply.isReplyToMulticastQuery();
        firewalled = firewalled && !multicast;
        measuredSpeed = measuredSpeed || multicast;
        boolean ifirewalled = !this.networkManager.acceptedIncomingConnection();
        int quality = reply.calculateQualityOfService(ifirewalled, this.networkManager);
        Set<? extends IpPort> proxies = reply.getPushProxies();
        boolean supportsFwt = reply.getSupportsFWTransfer();
        byte fwtVersion = reply.getFWTransferVersion();
        boolean tlsCapable = reply.isTLSCapable();
        int speed = multicast ? Integer.MAX_VALUE : ByteOrder.long2int(reply.getSpeed());
        return new HostData(clientGuid, messageGuid, speed, firewalled, busy, multicast, chatEnabled, browseHostEnabled, measuredSpeed, ip, port, quality, vendor, proxies, supportsFwt, fwtVersion, tlsCapable);
    }
}

