/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.ArrayList;

public class MerkleTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    public static final int HASHSIZE = 24;
    private static final byte[] MARKER = new byte[0];
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private final MessageDigest internalDigest;
    private final ArrayList<byte[]> nodes = new ArrayList();

    public MerkleTree(MessageDigest internalDigest) {
        super("merkletree");
        this.internalDigest = internalDigest;
    }

    protected int engineGetDigestLength() {
        return 24;
    }

    protected void engineUpdate(byte in) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = in;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    protected void engineUpdate(byte[] in, int offset, int length) {
        this.byteCount += (long)length;
        this.nodes.ensureCapacity(MerkleTree.log2Ceil(this.byteCount / 1024L));
        if (this.bufferOffset > 0) {
            int remaining = 1024 - this.bufferOffset;
            System.arraycopy(in, offset, this.buffer, this.bufferOffset, remaining);
            this.blockUpdate();
            this.bufferOffset = 0;
            length -= remaining;
            offset += remaining;
        }
        while (length >= 1024) {
            this.blockUpdate(in, offset, 1024);
            length -= 1024;
            offset += 1024;
        }
        if (length > 0) {
            System.arraycopy(in, offset, this.buffer, 0, length);
            this.bufferOffset = length;
        }
    }

    protected byte[] engineDigest() {
        byte[] hash = new byte[24];
        try {
            this.engineDigest(hash, 0, 24);
        }
        catch (DigestException e) {
            return null;
        }
        return hash;
    }

    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (len < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        byte[] ret = this.collapse();
        assert (ret != MARKER);
        System.arraycopy(ret, 0, buf, offset, 24);
        this.engineReset();
        return 24;
    }

    private byte[] collapse() {
        byte[] last = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            byte[] current = this.nodes.get(i);
            if (current == MARKER) continue;
            if (last == null) {
                last = current;
            } else {
                this.internalDigest.reset();
                this.internalDigest.update((byte)1);
                this.internalDigest.update(current);
                this.internalDigest.update(last);
                last = this.internalDigest.digest();
            }
            this.nodes.set(i, MARKER);
        }
        assert (last != null);
        return last;
    }

    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes.clear();
        this.internalDigest.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.blockUpdate(this.buffer, 0, this.bufferOffset);
    }

    protected void blockUpdate(byte[] buf, int pos, int len) {
        this.internalDigest.reset();
        this.internalDigest.update((byte)0);
        this.internalDigest.update(buf, pos, len);
        if (len == 0 && this.nodes.size() > 0) {
            return;
        }
        byte[] digest = this.internalDigest.digest();
        this.push(digest);
    }

    private void push(byte[] data) {
        if (!this.nodes.isEmpty()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                byte[] node = this.nodes.get(i);
                if (node == MARKER) {
                    this.nodes.set(i, data);
                    return;
                }
                this.internalDigest.reset();
                this.internalDigest.update((byte)1);
                this.internalDigest.update(node);
                this.internalDigest.update(data);
                data = this.internalDigest.digest();
                this.nodes.set(i, MARKER);
            }
        }
        this.nodes.add(data);
    }

    public static int log2Ceil(long number) {
        int n = 0;
        while (number > 1L) {
            ++number;
            number >>>= 1;
            ++n;
        }
        return n;
    }
}

