/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.service.ErrorService;
import org.limewire.setting.RemoteSettingController;
import org.limewire.setting.RemoteSettingManager;

public class SimppSettingsManager
implements RemoteSettingManager {
    private static final Log LOG = LogFactory.getLog(SimppSettingsManager.class);
    private final Properties _simppProps = new Properties();
    private final Map<String, String> _remainderSimppSettings = new HashMap<String, String>();
    private volatile RemoteSettingController _remoteController;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSimppSettings(String simppSettings) {
        if (!ApplicationSettings.USE_SIMPP.getValue()) {
            System.out.println("SimppSettingsManager.updateSimppSettings() - No more SIMPP, turned off");
            return;
        }
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            byte[] settings = null;
            try {
                settings = simppSettings.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException uex) {
                ErrorService.error(uex);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(settings);
            this._simppProps.clear();
            try {
                this._simppProps.load(bais);
            }
            catch (IOException iox) {
                LOG.error("IOX reading simpp properties", iox);
                return;
            }
            this.activateSimppSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateSimppSettings() {
        System.out.println("SimppSettingsManager.activateSimppSettings() - activating new settings");
        if (this._remoteController == null) {
            throw new IllegalStateException("No RemoteSettingController set!");
        }
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            for (Map.Entry<Object, Object> entry : this._simppProps.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.contains("SearchSettings.limeSearchTerms")) {
                    value = "frost;wire;frostwire;";
                }
                if (key.contains("SearchSettings.limeQRPEntries")) {
                    value = "frost;wire;frostwire";
                }
                if (key.contains("ResultPanel.SearchWarning")) {
                    value = "{0} Visit FrostWire.com for important updates.";
                }
                if (key.contains("ResultPanel.SearchBanner")) {
                    value = "  {0} Visit FrostWire.com for important updates.;http://www.frostwire.com/download;1.0f";
                }
                if (!key.contains("SWTBrowserSettings.remoteLimeWireStoreUrl")) continue;
                value = "http://www.frostwire.com";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnloadedValueFor(String simppKey) {
        RemoteSettingController remoteSettingController = this._remoteController;
        synchronized (remoteSettingController) {
            return this._remainderSimppSettings.remove(simppKey);
        }
    }

    public void setRemoteSettingController(RemoteSettingController controller) {
        this._remoteController = controller;
    }
}

