/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.SignatureVerifier;
import org.limewire.util.Base32;

public class SimppDataVerifier {
    private static final Log LOG = LogFactory.getLog(SimppDataVerifier.class);
    private static final byte SEP = 124;
    public final String DSA_ALGORITHM = "DSA";
    private byte[] simppPayload;
    private byte[] verifiedData;

    public SimppDataVerifier(byte[] payload) {
        this.simppPayload = payload;
    }

    public boolean verifySource() {
        int sepIndex = SimppDataVerifier.findSeperator(this.simppPayload);
        if (sepIndex < 0) {
            return false;
        }
        byte[] temp = new byte[sepIndex];
        System.arraycopy(this.simppPayload, 0, temp, 0, sepIndex);
        String base32 = null;
        try {
            base32 = new String(temp, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            return false;
        }
        byte[] signature = Base32.decode(base32);
        byte[] propsData = new byte[this.simppPayload.length - 1 - sepIndex];
        System.arraycopy(this.simppPayload, sepIndex + 1, propsData, 0, this.simppPayload.length - 1 - sepIndex);
        PublicKey pk = this.getPublicKey();
        if (pk == null) {
            return false;
        }
        String algo = "DSA";
        SignatureVerifier verifier = new SignatureVerifier(propsData, signature, pk, algo);
        boolean ret = verifier.verifySignature();
        if (ret) {
            this.verifiedData = propsData;
        }
        return ret;
    }

    public byte[] getVerifiedData() {
        return this.verifiedData;
    }

    private PublicKey getPublicKey() {
        String base32Enc = "GCBADOBQQIASYBQHFKDERTRYAQATBAQBD4BIDAIA7V7VHAI5OUJCSUW7JKOC53HE473BDN2SHTXUIAGDDY7YBNSREZUUKXKAEJI7WWJ5RVMPVP6F6W5DB5WLTNKWZV4BHOAB2NDP6JTGBN3LTFIKLJE7T7UAI6YQELBE7O5J277LPRQ37A5VPZ6GVCTBKDYE7OB7NU6FD3BQENKUCNNBNEJS6Z27HLRLMHLSV37SEIBRTHORJAA4OAQVACLWAUEPCURQXTFSSK4YFIXLQQF7AWA46UBIDAIA67Q2BBOWTM655S54VNODNOCXXF4ZJL537I5OVAXZK5GAWPIHQJTVCWKXR25NIWKP4ZYQOEEBQC2ESFTREPUEYKAWCO346CJSRTEKNYJ4CZ5IWVD4RUUOBI5ODYV3HJTVSFXKG7YL7IQTKYXR7NRHUAJEHPGKJ4N6VBIZBCNIQPP6CWXFT4DJFC3GL2AHWVJFMQAUYO76Z5ESUA4BQUAAFAMBADZ2DEAUI6Y6O4SJOM6M77DVWGUD7SDOJZK7QACMEUF6BZLNEWUZ26IYVH53F4IPJBUGY4I7QVN5V7POFP7TLL2M6PCU4B66DO5DD7USVJABNT5PGI27G7BQD7OMRPRMOWYQHZUC6GXIW2X7HVSL5FBA5HMKZ6OTOXSAXJH2AUTSHXIM22DPNZVBOSK7UDJFBNMKCKHSRYHNUCY";
        byte[] pubKeyBytes = Base32.decode(base32Enc);
        PublicKey ret = null;
        try {
            KeyFactory factory = KeyFactory.getInstance("DSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(pubKeyBytes);
            ret = factory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsax) {
            LOG.error("no algorithm", nsax);
        }
        catch (InvalidKeySpecException iksx) {
            LOG.error("invalid key", iksx);
        }
        return ret;
    }

    static int findSeperator(byte[] data) {
        int i;
        boolean found = false;
        for (i = 0; i < data.length; ++i) {
            if (data[i] != 124) continue;
            found = true;
            break;
        }
        if (found) {
            return i;
        }
        return -1;
    }
}

