/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SimppManager {
    private static final Log LOG = LogFactory.getLog(SimppManager.class);
    private static final String SIMPP_FILE = "simpp.xml";
    private static int MIN_VERSION = 3;
    private final List<SimppListener> listeners = new CopyOnWriteArrayList<SimppListener>();
    private volatile byte[] _simppBytes;
    private volatile String _propsStream;
    private final ExecutorService _processingQueue;
    private final CopyOnWriteArrayList<SimppSettingsManager> simppSettingsManagers;
    private volatile int _latestVersion;
    private Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Inject
    SimppManager(Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker) {
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.simppSettingsManagers = new CopyOnWriteArrayList();
        boolean problem = false;
        RandomAccessFile raf = null;
        this._processingQueue = ExecutorsHelper.newProcessingQueue("Simpp Handling Queue");
        try {
            File file = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
            raf = new RandomAccessFile(file, "r");
            byte[] content = new byte[(int)raf.length()];
            raf.readFully(content);
            SimppDataVerifier verifier = new SimppDataVerifier(content);
            boolean verified = false;
            this._latestVersion = 0;
            verified = verifier.verifySource();
            if (!verified) {
                LOG.debug("Unable to verify simpp message.");
                problem = true;
                return;
            }
            SimppParser parser = null;
            try {
                parser = new SimppParser(verifier.getVerifiedData());
            }
            catch (IOException iox) {
                LOG.error("IOX parsing simpp on disk", iox);
                problem = true;
                if (problem) {
                    this._latestVersion = MIN_VERSION;
                    this._propsStream = "";
                    this._simppBytes = "".getBytes();
                }
                if (raf == null) return;
                try {
                    raf.close();
                    return;
                }
                catch (IOException iox2) {
                    // empty catch block
                }
                return;
            }
            if (parser.getVersion() <= MIN_VERSION) {
                LOG.error("Version below min on disk, aborting simpp.");
                problem = true;
                return;
            }
            this._latestVersion = parser.getVersion();
            this._propsStream = parser.getPropsData();
            this._simppBytes = content;
            return;
        }
        catch (IOException iox) {
            LOG.error("IOX reading simpp xml on disk", iox);
            problem = true;
            return;
        }
        finally {
            if (problem) {
                this._latestVersion = MIN_VERSION;
                this._propsStream = "";
                this._simppBytes = "".getBytes();
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iox) {}
            }
        }
    }

    public int getVersion() {
        return this._latestVersion;
    }

    public byte[] getSimppBytes() {
        return this._simppBytes;
    }

    public String getPropsString() {
        return this._propsStream;
    }

    public void checkAndUpdate(final ReplyHandler handler, final byte[] simppPayload) {
        if (!ApplicationSettings.USE_SIMPP.getValue()) {
            System.out.println("SimppManager.checkAndUpdate() aborted - No more SIMPP, turned off");
            return;
        }
        if (simppPayload == null) {
            System.out.println("****SIMPPpayload IS CURRENTLY EMPTY*****");
            this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            return;
        }
        this.savefile(simppPayload, "checkandupdate.txt");
        final int myVersion = this._latestVersion;
        Runnable simppHandler = new Runnable(){

            public void run() {
                SimppDataVerifier verifier = new SimppDataVerifier(simppPayload);
                if (!verifier.verifySource()) {
                    ((NetworkUpdateSanityChecker)SimppManager.this.networkUpdateSanityChecker.get()).handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
                    return;
                }
                ((NetworkUpdateSanityChecker)SimppManager.this.networkUpdateSanityChecker.get()).handleValidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
                SimppParser parser = null;
                try {
                    System.out.println("Doing parsing....");
                    parser = new SimppParser(verifier.getVerifiedData());
                }
                catch (IOException iox) {
                    LOG.error("IOX parsing network simpp", iox);
                    return;
                }
                int version = parser.getVersion();
                if (version <= myVersion) {
                    LOG.error("Network simpp below current version, aborting.");
                    return;
                }
                SimppManager.this._latestVersion = version;
                SimppManager.access$302(SimppManager.this, simppPayload);
                SimppManager.this._propsStream = parser.getPropsData();
                String props = parser.getPropsData();
                for (SimppSettingsManager ssm : SimppManager.this.simppSettingsManagers) {
                    ssm.updateSimppSettings(props);
                }
                for (int i = 0; i < 5 && !SimppManager.this.save(); ++i) {
                }
                for (SimppListener listener : SimppManager.this.listeners) {
                    listener.simppUpdated(version);
                }
            }
        };
        this._processingQueue.execute(simppHandler);
    }

    public void addSimppSettingsManager(SimppSettingsManager simppSettingsManager) {
        this.simppSettingsManagers.add(simppSettingsManager);
    }

    public List<SimppSettingsManager> getSimppSettingsManagers() {
        return this.simppSettingsManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savefile(byte[] content, String filename) {
        File destfile = new File(CommonUtils.getUserSettingsDir(), filename);
        OutputStream simppWriter = null;
        try {
            simppWriter = new BufferedOutputStream(new FileOutputStream(destfile));
            simppWriter.write(content);
            simppWriter.flush();
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (simppWriter != null) {
                try {
                    simppWriter.close();
                }
                catch (IOException ignored) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        File tmp = new File(CommonUtils.getUserSettingsDir(), "simpp.xml.tmp");
        File simpp = new File(CommonUtils.getUserSettingsDir(), SIMPP_FILE);
        OutputStream simppWriter = null;
        try {
            simppWriter = new BufferedOutputStream(new FileOutputStream(tmp));
            simppWriter.write(this._simppBytes);
            simppWriter.flush();
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (simppWriter != null) {
                try {
                    simppWriter.close();
                }
                catch (IOException ignored) {}
            }
        }
        FilterInputStream dis = null;
        byte[] data = new byte[this._simppBytes.length];
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(tmp)));
            ((DataInputStream)dis).readFully(data);
            if (!Arrays.equals(data, this._simppBytes)) {
                boolean ignored = false;
                return ignored;
            }
        }
        catch (IOException bad) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ignored) {}
            }
        }
        return FileUtils.forceRename(tmp, simpp);
    }

    public void addListener(SimppListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SimppListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ byte[] access$302(SimppManager x0, byte[] x1) {
        x0._simppBytes = x1;
        return x1;
    }
}

