/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.limegroup.gnutella.spam.AbstractToken;
import com.limegroup.gnutella.spam.Token;

public class VendorToken
extends AbstractToken {
    private static final long serialVersionUID = -3593261726550970847L;
    private static final byte INITAL_GOOD = 20;
    private static final int MAX = 100;
    public static final VendorToken ALT = new ALTVendor();
    public static final VendorToken LIME = new VendorToken("LIME");
    public static final VendorToken BEAR = new VendorToken("BEAR");
    public static final VendorToken RAZA = new VendorToken("RAZA");
    public static final VendorToken OREO = new VendorToken("GNZL");
    public static final VendorToken GNUC = new VendorToken("GNUC");
    public static final VendorToken GTKG = new VendorToken("GTKG");
    public static final VendorToken GIFT = new VendorToken("GIFT");
    private final String vendor;
    private final int hashCode;
    private byte _good;
    private byte _bad;

    public static VendorToken getToken(String vendor) {
        if (vendor.equals("ALT")) {
            return ALT;
        }
        if (vendor.equals("LIME")) {
            return LIME;
        }
        if (vendor.equals("BEAR")) {
            return BEAR;
        }
        if (vendor.equals("RAZA")) {
            return RAZA;
        }
        if (vendor.equals("GNZL")) {
            return OREO;
        }
        if (vendor.equals("GNUC")) {
            return GNUC;
        }
        if (vendor.equals("GTKG")) {
            return GTKG;
        }
        if (vendor.equals("GIFT")) {
            return GIFT;
        }
        return new VendorToken(vendor);
    }

    private VendorToken(String vendor) {
        this.vendor = vendor;
        this.hashCode = vendor.hashCode();
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof VendorToken)) {
            return false;
        }
        if (this.hashCode != o.hashCode()) {
            return false;
        }
        return this.vendor.equals(((VendorToken)o).vendor);
    }

    public Token.TokenType getType() {
        return Token.TokenType.VENDOR;
    }

    public float getRating() {
        return (float)Math.pow(1.0f * (float)this._bad / (float)(this._good + this._bad + 1), 2.0);
    }

    public void rate(Token.Rating rating) {
        this._age = 0;
        switch (rating) {
            case PROGRAM_MARKED_GOOD: {
                this._good = (byte)(this._good + 1);
                break;
            }
            case PROGRAM_MARKED_SPAM: {
                this._bad = (byte)(this._bad + 1);
                break;
            }
            case USER_MARKED_GOOD: {
                this._bad = (byte)(this._bad / 2);
                break;
            }
            case USER_MARKED_SPAM: {
                this._bad = (byte)Math.min(this._bad + 2, 100);
                break;
            }
            case CLEARED: {
                this._bad = 0;
                this._good = (byte)20;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type of rating");
            }
        }
        if (this._good >= 100 || this._bad >= 100) {
            this._good = (byte)(this._good * 9 / 10);
            this._bad = (byte)(this._bad * 9 / 10);
        }
    }

    private static class ALTVendor
    extends VendorToken {
        private static final long serialVersionUID = 703031386150175127L;

        ALTVendor() {
            super("ALT");
        }

        public float getRating() {
            return 0.0f;
        }

        public void rate(Token.Rating rating) {
        }
    }
}

