/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import com.limegroup.gnutella.tigertree.HashTreeFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Tuple;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class HashTreeCacheImpl
implements HashTreeCache {
    private static final Log LOG = LogFactory.getLog(HashTreeCacheImpl.class);
    private final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("TreeHashTread");
    private final URN BUSH = URN.INVALID;
    private final Map<URN, URN> ROOT_MAP;
    private final Map<URN, HashTree> TREE_MAP;
    private final File ROOT_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttroot.cache");
    private final File TREE_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttrees.cache");
    private volatile boolean dirty = false;
    private final HashTreeFactory tigerTreeFactory;

    @Inject
    HashTreeCacheImpl(HashTreeFactory tigerTreeFactory) {
        this.tigerTreeFactory = tigerTreeFactory;
        Tuple<Map<URN, URN>, Map<URN, HashTree>> tuple = this.loadCaches();
        this.ROOT_MAP = tuple.getFirst();
        this.TREE_MAP = tuple.getSecond();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashTree getHashTreeAndWait(FileDesc fd, long timeout) throws InterruptedException, TimeoutException {
        if (fd instanceof IncompleteFileDesc) {
            throw new IllegalArgumentException("fd must not inherit from IncompleFileDesc");
        }
        HashTreeCacheImpl hashTreeCacheImpl = this;
        synchronized (hashTreeCacheImpl) {
            URN root = this.ROOT_MAP.get(fd.getSHA1Urn());
            if (root != null && root != this.BUSH) {
                return this.TREE_MAP.get(root);
            }
            this.ROOT_MAP.put(fd.getSHA1Urn(), this.BUSH);
        }
        Future<?> future = this.QUEUE.submit(new HashRunner(fd));
        try {
            future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        HashTreeCacheImpl hashTreeCacheImpl2 = this;
        synchronized (hashTreeCacheImpl2) {
            URN root = this.ROOT_MAP.get(fd.getSHA1Urn());
            if (root != null && root != this.BUSH) {
                return this.TREE_MAP.get(root);
            }
        }
        throw new RuntimeException("hash tree was not calculated");
    }

    @Override
    public synchronized HashTree getHashTree(FileDesc fd) {
        URN root = this.ROOT_MAP.get(fd.getSHA1Urn());
        if (root == null || root == this.BUSH) {
            return null;
        }
        HashTree tree = this.TREE_MAP.get(root);
        if (tree == null) {
            this.ROOT_MAP.put(fd.getSHA1Urn(), this.BUSH);
            this.QUEUE.execute(new HashRunner(fd));
        }
        return tree;
    }

    @Override
    public synchronized HashTree getHashTree(URN sha1) {
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN root = this.ROOT_MAP.get(sha1);
        if (root == null || root == this.BUSH) {
            return null;
        }
        return this.TREE_MAP.get(root);
    }

    @Override
    public synchronized URN getHashTreeRootForSha1(URN sha1) {
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN root = this.ROOT_MAP.get(sha1);
        if (root == this.BUSH) {
            root = null;
        }
        return root;
    }

    @Override
    public synchronized void purgeTree(URN sha1) {
        if (!sha1.isSHA1()) {
            throw new IllegalArgumentException();
        }
        URN root = this.ROOT_MAP.remove(sha1);
        if (root == null) {
            return;
        }
        if (this.TREE_MAP.remove(root) != null) {
            this.dirty = true;
        }
    }

    @Override
    public synchronized void addHashTree(URN sha1, HashTree tree) {
        URN root = tree.getTreeRootUrn();
        this.addRoot(sha1, root);
        if (tree.isGoodDepth()) {
            this.ROOT_MAP.put(sha1, root);
            this.TREE_MAP.put(root, tree);
            this.dirty = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("added hashtree for urn " + sha1 + ";" + tree.getRootHash());
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("hashtree for urn " + sha1 + " had bad depth");
        }
    }

    @Override
    public synchronized void addRoot(URN sha1, URN ttroot) {
        if (!sha1.isSHA1() || !ttroot.isTTRoot()) {
            throw new IllegalArgumentException();
        }
        this.dirty |= !ttroot.equals(this.ROOT_MAP.put(sha1, ttroot));
    }

    private Tuple<Map<URN, URN>, Map<URN, HashTree>> loadCaches() {
        Object trees;
        HashMap roots;
        try {
            roots = this.ROOT_CACHE_FILE.exists() ? FileUtils.readObject(this.ROOT_CACHE_FILE) : new HashMap();
            trees = this.TREE_CACHE_FILE.exists() ? FileUtils.readObject(this.TREE_CACHE_FILE) : new HashMap();
        }
        catch (Throwable t) {
            LOG.debug("Error reading from disk.", t);
            roots = new HashMap();
            trees = new HashMap();
        }
        Map<URN, URN> rootsMap = GenericsUtils.scanForMap(roots, URN.class, URN.class, GenericsUtils.ScanMode.REMOVE);
        Map<URN, HashTree> treesMap = GenericsUtils.scanForMap(trees, URN.class, HashTree.class, GenericsUtils.ScanMode.REMOVE);
        treesMap.keySet().retainAll(rootsMap.values());
        Iterator<Object> iter = rootsMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<URN, URN> e = iter.next();
            if (e.getKey().isSHA1() && e.getValue().isTTRoot()) continue;
            iter.remove();
        }
        iter = treesMap.keySet().iterator();
        while (iter.hasNext()) {
            URN urn = (URN)iter.next();
            if (urn.isTTRoot()) continue;
            iter.remove();
        }
        return new Tuple<Map<URN, URN>, Map<URN, HashTree>>(rootsMap, treesMap);
    }

    private void removeOldEntries(Map<URN, URN> roots, Map<URN, HashTree> map, FileManager fileManager, DownloadManager downloadManager) {
        Iterator<URN> iter = roots.keySet().iterator();
        while (iter.hasNext()) {
            URN sha1 = iter.next();
            if (roots.get(sha1) != this.BUSH && (fileManager.getFileDescForUrn(sha1) != null || downloadManager.getIncompleteFileManager().getFileForUrn(sha1) != null || Math.random() > (double)(map.size() / 200))) continue;
            iter.remove();
            map.remove(roots.get(sha1));
            this.dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistCache(FileManager fileManager, DownloadManager downloadManager) {
        HashMap<URN, URN> roots;
        HashMap<URN, HashTree> trees;
        if (!this.dirty) {
            return;
        }
        HashTreeCacheImpl hashTreeCacheImpl = this;
        synchronized (hashTreeCacheImpl) {
            trees = new HashMap<URN, HashTree>(this.TREE_MAP);
            roots = new HashMap<URN, URN>(this.ROOT_MAP);
        }
        this.removeOldEntries(roots, trees, fileManager, downloadManager);
        hashTreeCacheImpl = this;
        synchronized (hashTreeCacheImpl) {
            this.TREE_MAP.clear();
            this.TREE_MAP.putAll(trees);
            this.ROOT_MAP.clear();
            this.ROOT_MAP.putAll(roots);
        }
        try {
            FileUtils.writeObject(this.ROOT_CACHE_FILE, roots);
            FileUtils.writeObject(this.TREE_CACHE_FILE, trees);
            this.dirty = false;
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fd) {
            this.FD = fd;
        }

        public void run() {
            try {
                URN sha1 = this.FD.getSHA1Urn();
                if (HashTreeCacheImpl.this.getHashTree(sha1) == null) {
                    HashTree tree = HashTreeCacheImpl.this.tigerTreeFactory.createHashTree(this.FD);
                    HashTreeCacheImpl.this.addHashTree(sha1, tree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

