/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.uploader.HTTPUploadSession;
import com.limegroup.gnutella.uploader.UploadType;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.ssl.SSLUtils;

public abstract class AbstractUploader
implements Uploader {
    private static final Log LOG = LogFactory.getLog(AbstractUploader.class);
    private final HTTPUploadSession session;
    private long totalAmountUploadedBefore;
    private long totalAmountUploaded;
    private long amountUploaded;
    private final Object bwLock = new Object();
    private boolean ignoreTotalAmountUploaded;
    private long fileSize;
    private String userAgent;
    private final String filename;
    private Uploader.UploadStatus state = Uploader.UploadStatus.CONNECTING;
    private Uploader.UploadStatus lastTransferState;
    private boolean firstReply;
    private boolean chatEnabled;
    private boolean browseHostEnabled;
    private boolean forcedShare = false;
    private boolean priorityShare = false;
    private FileDesc fileDesc;
    private int index;
    private String host;
    private int port = -1;
    private UploadType uploadType;
    private final TcpBandwidthStatistics tcpBandwidthStatistics;

    public AbstractUploader(String fileName, HTTPUploadSession session, TcpBandwidthStatistics tcpBandwidthStatistics) {
        this.session = session;
        this.filename = fileName;
        this.firstReply = true;
        this.tcpBandwidthStatistics = tcpBandwidthStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize() {
        this.setState(Uploader.UploadStatus.CONNECTING);
        this.host = null;
        this.port = -1;
        Object object = this.bwLock;
        synchronized (object) {
            this.totalAmountUploadedBefore = 0L;
            if (!this.ignoreTotalAmountUploaded) {
                this.totalAmountUploaded += this.amountUploaded;
            }
            this.ignoreTotalAmountUploaded = false;
            this.amountUploaded = 0L;
        }
        this.firstReply = false;
    }

    public void setFileDesc(FileDesc fd) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting file description for " + this + ": " + fd);
        }
        this.fileDesc = fd;
        this.forcedShare = SharingUtils.isForcedShare(fd);
        this.priorityShare = SharingUtils.isApplicationSpecialShare(fd.getFile());
        this.index = fd.getIndex();
        this.setFileSize(fd.getFileSize());
    }

    public void setState(Uploader.UploadStatus state) {
        assert (this.state != state);
        this.lastTransferState = this.state;
        this.state = state;
    }

    public int getQueuePosition() {
        if (this.lastTransferState != Uploader.UploadStatus.QUEUED || this.state == Uploader.UploadStatus.INTERRUPTED) {
            return -1;
        }
        return this.session.positionInQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAmountUploaded(long amount) {
        Object object = this.bwLock;
        synchronized (object) {
            this.addAmountUploaded((int)(amount - this.amountUploaded));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAmountUploaded(int written) {
        assert (written >= 0);
        if (written > 0 && this.tcpBandwidthStatistics != null) {
            if (this.isForcedShare()) {
                this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_INNETWORK_UPSTREAM).addData(written);
            } else {
                this.tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_BODY_UPSTREAM).addData(written);
            }
        }
        Object object = this.bwLock;
        synchronized (object) {
            this.amountUploaded += (long)written;
        }
    }

    public boolean isInactive() {
        switch (this.state) {
            case COMPLETE: 
            case INTERRUPTED: {
                return true;
            }
        }
        return false;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFileName() {
        return this.filename;
    }

    public Uploader.UploadStatus getState() {
        return this.state;
    }

    public Uploader.UploadStatus getLastTransferState() {
        return this.lastTransferState;
    }

    public String getHost() {
        return this.host != null ? this.host : this.session.getHost();
    }

    public boolean isChatEnabled() {
        return this.chatEnabled;
    }

    public boolean isBrowseHostEnabled() {
        return this.browseHostEnabled;
    }

    public int getGnutellaPort() {
        return this.port;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isForcedShare() {
        return this.forcedShare;
    }

    public boolean isPriorityShare() {
        return this.priorityShare;
    }

    protected boolean isFirstReply() {
        return this.firstReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long amountUploaded() {
        Object object = this.bwLock;
        synchronized (object) {
            return this.amountUploaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalAmountUploaded() {
        Object object = this.bwLock;
        synchronized (object) {
            if (this.ignoreTotalAmountUploaded) {
                return this.amountUploaded;
            }
            if (this.totalAmountUploadedBefore > 0L) {
                return this.totalAmountUploadedBefore + this.amountUploaded;
            }
            return this.totalAmountUploaded + this.amountUploaded;
        }
    }

    public FileDesc getFileDesc() {
        return this.fileDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureBandwidth() {
        int written;
        Object object = this.bwLock;
        synchronized (object) {
            written = (int)(this.totalAmountUploaded + this.amountUploaded);
        }
        this.session.measureBandwidth(written);
    }

    public float getMeasuredBandwidth() throws InsufficientDataException {
        return this.session.getMeasuredBandwidth();
    }

    public float getAverageBandwidth() {
        return this.session.getAverageBandwidth();
    }

    public String getCustomIconDescriptor() {
        return null;
    }

    public UploadType getUploadType() {
        return this.uploadType;
    }

    public void setUploadType(UploadType type) {
        this.uploadType = type;
    }

    public void setBrowseHostEnabled(boolean browseHostEnabled) {
        this.browseHostEnabled = browseHostEnabled;
    }

    public void setChatEnabled(boolean chatEnabled) {
        this.chatEnabled = chatEnabled;
    }

    public void setGnutellaPort(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTotalAmountUploadedBefore(int totalAmountReadBefore) {
        Object object = this.bwLock;
        synchronized (object) {
            this.totalAmountUploadedBefore = totalAmountReadBefore;
        }
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String toString() {
        return this.getClass().getName() + "[host=" + this.getHost() + ",index=" + this.index + ",filename=" + this.filename + ",state=" + (Object)((Object)this.state) + ",lastTransferState=" + (Object)((Object)this.lastTransferState) + "]";
    }

    public HTTPUploadSession getSession() {
        return this.session;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public boolean getIgnoreTotalAmountUploaded() {
        return this.ignoreTotalAmountUploaded;
    }

    public void setIgnoreTotalAmountUploaded(boolean ignoreTotalAmountUploaded) {
        this.ignoreTotalAmountUploaded = ignoreTotalAmountUploaded;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public boolean isTLSCapable() {
        return SSLUtils.isTLSEnabled(this.getSession().getIOSession().getSocket());
    }

    public String getAddress() {
        return this.getSession().getHost();
    }

    public InetAddress getInetAddress() {
        return this.getSession().getIOSession().getSocket().getInetAddress();
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public int getPort() {
        int gnutellaPort = this.getGnutellaPort();
        if (gnutellaPort != -1) {
            return gnutellaPort;
        }
        return ((InetSocketAddress)this.getSession().getIOSession().getRemoteAddress()).getPort();
    }
}

