/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.connection.BasicQueue;
import com.limegroup.gnutella.connection.ConnectionStats;
import com.limegroup.gnutella.connection.MessageWriter;
import com.limegroup.gnutella.connection.SentMessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.limewire.http.AbstractHttpNIOEntity;
import org.limewire.http.HttpCoreUtils;
import org.limewire.http.nio.ContentEncoderChannel;
import org.limewire.nio.channel.NoInterestWritableByteChannel;

public class BrowseRequestHandler
implements HttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(BrowseRequestHandler.class);
    private final HTTPUploadSessionManager sessionManager;
    private final QueryRequestFactory queryRequestFactory;
    private final FileManager fileManager;
    private final MessageRouter messageRouter;

    @Inject
    BrowseRequestHandler(HTTPUploadSessionManager sessionManager, QueryRequestFactory queryRequestFactory, FileManager fileManager, MessageRouter messageRouter) {
        this.sessionManager = sessionManager;
        this.queryRequestFactory = queryRequestFactory;
        this.fileManager = fileManager;
        this.messageRouter = messageRouter;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HTTPUploader uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.BROWSE_HOST, "Browse-File");
        uploader.setState(Uploader.UploadStatus.BROWSE_HOST);
        if (!HttpCoreUtils.hasHeaderListValue(request, "Accept", "application/x-gnutella-packets")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Browse request is missing Accept header");
            }
            response.setStatusCode(406);
        } else {
            response.setEntity(new BrowseResponseEntity(uploader));
            response.setStatusCode(200);
        }
        this.sessionManager.sendResponse(uploader, response);
    }

    public class BrowseResponseEntity
    extends AbstractHttpNIOEntity {
        private static final int RESPONSES_PER_REPLY = 10;
        private static final int MAX_PENDING_REPLIES = 5;
        private final HTTPUploader uploader;
        private QueryRequest query;
        private Iterator<Response> iterable;
        private MessageWriter sender;
        private volatile int pendingMessageCount = 0;

        public BrowseResponseEntity(HTTPUploader uploader) {
            this.uploader = uploader;
            this.setContentType("application/x-gnutella-packets");
        }

        public long getContentLength() {
            return -1L;
        }

        public void initialize(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
            SentMessageHandler sentMessageHandler = new SentMessageHandler(){

                public void processSentMessage(Message m) {
                    BrowseResponseEntity.this.uploader.addAmountUploaded(m.getTotalLength());
                    BrowseResponseEntity.this.pendingMessageCount--;
                }
            };
            this.sender = new MessageWriter(new ConnectionStats(), new BasicQueue(), sentMessageHandler);
            this.sender.setWriteChannel(new NoInterestWritableByteChannel(new ContentEncoderChannel(contentEncoder)));
            this.query = BrowseRequestHandler.this.queryRequestFactory.createBrowseHostQuery();
            this.iterable = BrowseRequestHandler.this.fileManager.getIndexingIterator(this.query.desiresXMLResponses() || this.query.desiresOutOfBandReplies());
        }

        public boolean writeContent(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
            this.addMessages();
            boolean more = this.sender.handleWrite();
            assert (more || this.pendingMessageCount == 0);
            this.activateTimeout();
            return more || this.iterable.hasNext();
        }

        private void addMessages() {
            if (this.pendingMessageCount >= 5) {
                return;
            }
            ArrayList<Response> responses = new ArrayList<Response>(10);
            for (int i = 0; this.iterable.hasNext() && i < 10; ++i) {
                responses.add(this.iterable.next());
            }
            Iterable<QueryReply> it = BrowseRequestHandler.this.messageRouter.responsesToQueryReplies(responses.toArray(new Response[0]), this.query);
            for (QueryReply queryReply : it) {
                this.sender.send(queryReply);
                ++this.pendingMessageCount;
            }
        }

        public void finished() {
            this.deactivateTimeout();
            this.sender = null;
        }

        public void timeout() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Browse request timed out");
            }
            this.uploader.stop();
        }
    }
}

