/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.http.FeaturesWriter;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HTTPHeaderUtils {
    private final NetworkManager networkManager;
    private final FeaturesWriter featuresWriter;
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HTTPHeaderUtils(FeaturesWriter featuresWriter, NetworkManager networkManager, Provider<ConnectionManager> connectionManager, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.featuresWriter = featuresWriter;
        this.connectionManager = connectionManager;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void addRangeHeader(HttpResponse response, HTTPUploader uploader, FileDesc fd) {
        URN sha1;
        if (fd instanceof IncompleteFileDesc && (sha1 = uploader.getFileDesc().getSHA1Urn()) != null) {
            IncompleteFileDesc ifd = (IncompleteFileDesc)fd;
            response.addHeader(HTTPHeaderName.AVAILABLE_RANGES.create(ifd));
        }
    }

    public static String encodePushProxies(Collection<? extends IpPort> proxies, String separator, int max) {
        if (proxies.isEmpty()) {
            throw new IllegalArgumentException("Can't encode empty set of proxies");
        }
        StringBuilder buf = new StringBuilder();
        int proxiesWritten = 0;
        BitNumbers bn = HTTPHeaderUtils.getTLSIndices(proxies, max);
        for (IpPort ipPort : proxies) {
            if (proxiesWritten >= max) break;
            buf.append(ipPort.getAddress()).append(":").append(ipPort.getPort()).append(separator);
            ++proxiesWritten;
        }
        if (!bn.isEmpty()) {
            buf.insert(0, "pptls=" + bn.toHexString() + separator);
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }

    public Set<Connectable> decodePushProxies(String httpValue, String separator) {
        HashSet<Connectable> newSet = new HashSet<Connectable>();
        StringTokenizer tok = new StringTokenizer(httpValue, separator);
        BitNumbers tlsProxies = null;
        while (tok.hasMoreTokens()) {
            String proxy = tok.nextToken().trim();
            if (newSet.size() == 0 && proxy.startsWith("pptls")) {
                try {
                    String value = HTTPUtils.parseValue(proxy);
                    if (value == null) continue;
                    try {
                        tlsProxies = new BitNumbers(value);
                    }
                    catch (IllegalArgumentException ignored) {
                    }
                }
                catch (IOException invalid) {}
                continue;
            }
            boolean tlsCapable = tlsProxies != null && tlsProxies.isSet(newSet.size());
            try {
                Connectable ipp = NetworkUtils.parseIpPort(proxy, tlsCapable);
                if (this.networkInstanceUtils.isPrivateAddress(ipp.getInetAddress())) continue;
                newSet.add(ipp);
            }
            catch (IOException ohWell) {
                tlsProxies = null;
            }
        }
        return newSet;
    }

    public static BitNumbers getTLSIndices(Collection<? extends IpPort> ipPorts) {
        return HTTPHeaderUtils.getTLSIndices(ipPorts, ipPorts.size());
    }

    public static BitNumbers getTLSIndices(Collection<? extends IpPort> ipPorts, int max) {
        BitNumbers bn = new BitNumbers(max);
        int i = 0;
        for (IpPort ipPort : ipPorts) {
            if (i >= max) break;
            if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                bn.set(i);
            }
            ++i;
        }
        return bn;
    }

    private String encodePushProxies() {
        if (this.networkManager.acceptedIncomingConnection()) {
            return null;
        }
        Set<Connectable> proxies = this.connectionManager.get().getPushProxies();
        return !proxies.isEmpty() ? HTTPHeaderUtils.encodePushProxies(proxies, ",", 4) : null;
    }

    public List<Header> getFirewalledHeaders() {
        String proxies = this.encodePushProxies();
        if (proxies != null) {
            Header proxiesHeader = HTTPHeaderName.PROXIES.create(proxies);
            if (this.networkManager.canDoFWT()) {
                return Arrays.asList(proxiesHeader, HTTPHeaderName.FWTPORT.create(this.networkManager.getStableUDPPort() + ""));
            }
            return Arrays.asList(proxiesHeader);
        }
        return Collections.emptyList();
    }

    public void addProxyHeader(HttpResponse response) {
        for (Header header : this.getFirewalledHeaders()) {
            response.addHeader(header);
        }
    }

    public void addAltLocationsHeader(HttpResponse response, AltLocTracker altLocTracker, AltLocManager altLocManager) {
        Collection<PushAltLoc> pushes;
        response.addHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN.create(altLocTracker.getUrn()));
        Collection<DirectAltLoc> direct = altLocTracker.getNextSetOfAltsToSend(altLocManager);
        if (direct.size() > 0) {
            ArrayList<HTTPHeaderValue> ordered = new ArrayList<HTTPHeaderValue>(direct.size());
            final BitNumbers bn = new BitNumbers(direct.size());
            for (DirectAltLoc al : direct) {
                IpPort ipp = al.getHost();
                if (ipp instanceof Connectable && ((Connectable)ipp).isTLSCapable()) {
                    bn.set(ordered.size());
                }
                ordered.add(al);
            }
            if (!bn.isEmpty()) {
                ordered.add(0, new HTTPHeaderValue(){

                    public String httpStringValue() {
                        return "tls=" + bn.toHexString();
                    }
                });
            }
            response.addHeader(HTTPHeaderName.ALT_LOCATION.create(new HTTPHeaderValueCollection(ordered)));
        }
        if (altLocTracker.wantsFAlts() && (pushes = altLocTracker.getNextSetOfPushAltsToSend(altLocManager)).size() > 0) {
            response.addHeader(HTTPHeaderName.FALT_LOCATION.create(new HTTPHeaderValueCollection(pushes)));
        }
    }

    public void addFeatures(HttpResponse response) {
        Set<HTTPHeaderValue> features = this.featuresWriter.getFeaturesValue();
        if (features.size() > 0) {
            response.addHeader(HTTPHeaderName.FEATURES.create(new HTTPHeaderValueCollection(features)));
        }
    }
}

