/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class LimitReachedRequestHandler
implements HttpRequestHandler {
    public static final String RETRY_AFTER_VALIDATING = "20";
    public static final int RETRY_AFTER_TIME = 900;
    private static final String NO_ALT_LOCS_RETRY_AFTER = "1200";
    private static final String NORMAL_RETRY_AFTER = "900";
    private static final String ERROR_MESSAGE = "Server busy.  Too many active uploads.";
    private static final String VALIDATING_MSG = "Validating file.  One moment please.";
    private final boolean validating;
    private final HTTPUploader uploader;
    private final FileDesc fd;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final AltLocManager altLocManager;

    LimitReachedRequestHandler(HTTPUploader uploader, HTTPHeaderUtils httpHeaderUtils, AltLocManager altLocManager) {
        this.uploader = uploader;
        this.validating = false;
        this.fd = uploader.getFileDesc();
        this.httpHeaderUtils = httpHeaderUtils;
        this.altLocManager = altLocManager;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        this.httpHeaderUtils.addProxyHeader(response);
        this.httpHeaderUtils.addAltLocationsHeader(response, this.uploader.getAltLocTracker(), this.altLocManager);
        String errorMsg = ERROR_MESSAGE;
        if (this.fd != null) {
            URN sha1 = this.fd.getSHA1Urn();
            if (this.validating) {
                errorMsg = VALIDATING_MSG;
                response.addHeader(HTTPHeaderName.RETRY_AFTER.create(RETRY_AFTER_VALIDATING));
            } else if (sha1 != null) {
                String retry = !this.altLocManager.hasAltlocs(sha1) ? NO_ALT_LOCS_RETRY_AFTER : NORMAL_RETRY_AFTER;
                response.addHeader(HTTPHeaderName.RETRY_AFTER.create(retry));
                this.httpHeaderUtils.addRangeHeader(response, this.uploader, this.fd);
            } else {
                response.addHeader(HTTPHeaderName.RETRY_AFTER.create(NO_ALT_LOCS_RETRY_AFTER));
            }
        }
        this.uploader.setState(Uploader.UploadStatus.LIMIT_REACHED);
        response.setStatusCode(503);
        response.setEntity(new StringEntity(errorMsg));
    }
}

