/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.tigertree.HashTreeWriteHandler;
import com.limegroup.gnutella.tigertree.ThexWriter;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.limewire.http.AbstractHttpNIOEntity;
import org.limewire.http.nio.ContentEncoderChannel;
import org.limewire.nio.NBThrottle;

public class THEXResponseEntity
extends AbstractHttpNIOEntity {
    private static final NBThrottle THROTTLE = new NBThrottle(true, UploadSettings.THEX_UPLOAD_SPEED.getValue());
    private HTTPUploader uploader;
    private final HashTreeWriteHandler tigerWriteHandler;
    private ThexWriter writer;
    private long size;

    public THEXResponseEntity(HTTPUploader uploader, HashTreeWriteHandler tigerWriteHandler, long size) {
        this.uploader = uploader;
        this.tigerWriteHandler = tigerWriteHandler;
        this.size = size;
        this.setContentType(tigerWriteHandler.getOutputType());
    }

    public long getContentLength() {
        return this.size;
    }

    public void initialize(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
        this.writer = this.tigerWriteHandler.createAsyncWriter();
        THROTTLE.setRate(UploadSettings.THEX_UPLOAD_SPEED.getValue());
        this.uploader.getSession().getIOSession().setThrottle(THROTTLE);
    }

    public boolean writeContent(ContentEncoder contentEncoder, IOControl ioctrl) throws IOException {
        boolean more = this.writer.process(new ContentEncoderChannel(contentEncoder), null);
        this.uploader.setAmountUploaded(this.writer.getAmountProcessed());
        this.activateTimeout();
        return more;
    }

    public void finished() {
        this.deactivateTimeout();
        this.writer = null;
    }

    public void timeout() {
        this.uploader.stop();
    }
}

