/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCNetworks {
    private Map<Integer, Integer> counts = new HashMap<Integer, Integer>();
    static final Comparator<Map.Entry<Integer, Integer>> CLASS_C_COMPARATOR = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> a, Map.Entry<Integer, Integer> b) {
            return b.getValue().compareTo(a.getValue());
        }
    };

    public void addAll(Collection<? extends IpPort> c) {
        for (IpPort ipPort : c) {
            this.add(ipPort.getInetAddress(), 1);
        }
    }

    public void add(InetAddress addr, int count) {
        this.add(NetworkUtils.getClassC(addr), count);
    }

    public void add(int masked, int count) {
        Integer num = this.counts.get(masked &= 0xFFFFFF00);
        if (num == null) {
            num = 0;
        }
        num = num + count;
        this.counts.put(masked, num);
    }

    public List<Map.Entry<Integer, Integer>> getTop() {
        ArrayList<Map.Entry<Integer, Integer>> ret = new ArrayList<Map.Entry<Integer, Integer>>(this.counts.size());
        ret.addAll(this.counts.entrySet());
        Collections.sort(ret, CLASS_C_COMPARATOR);
        return ret;
    }

    public byte[] getTopInspectable(int number) {
        List<Map.Entry<Integer, Integer>> top = this.getTop();
        number = Math.min(top.size(), number);
        byte[] ret = new byte[8 * number];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : top) {
            if (i == number) break;
            ByteOrder.int2beb((int)entry.getKey(), ret, i * 8);
            ByteOrder.int2beb((int)entry.getValue(), ret, i * 8 + 4);
            ++i;
        }
        return ret;
    }

    public Map<Integer, Integer> getMap() {
        return this.counts;
    }

    public void addAll(ClassCNetworks ... other) {
        for (ClassCNetworks c : other) {
            for (int classC : c.getMap().keySet()) {
                this.add(classC, (int)c.getMap().get(classC));
            }
        }
    }
}

