/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.util.FECUtils;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECCodeFactory;
import com.onionnetworks.util.Buffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class FECUtilsImpl
implements FECUtils {
    private FECCodeFactory fecFactory;

    @Inject
    public FECUtilsImpl() {
        System.setProperty("com.onionnetworks.fec.keys", "pure8,pure16");
    }

    @Override
    public List<byte[]> encode(byte[] data, int packetSize, float redundancy) {
        int i;
        if (this.fecFactory == null) {
            this.fecFactory = FECCodeFactory.getDefault();
        }
        int numPackets = data.length / packetSize + (data.length % packetSize == 0 ? 0 : 1);
        int numChecksums = (int)Math.ceil((float)numPackets * redundancy);
        FECCode code = this.fecFactory.createFECCode(numPackets, numChecksums);
        Buffer[] chunks = new Buffer[numPackets];
        Buffer[] out = new Buffer[numChecksums];
        int[] indices = new int[numChecksums];
        for (i = 0; i < numPackets; ++i) {
            byte[] b = new byte[packetSize];
            System.arraycopy(data, i * packetSize, b, 0, Math.min(packetSize, data.length - i * packetSize));
            chunks[i] = new Buffer(b);
            out[i] = new Buffer(new byte[packetSize]);
            indices[i] = i;
        }
        for (i = numPackets; i < numChecksums; ++i) {
            out[i] = new Buffer(new byte[packetSize]);
            indices[i] = i;
        }
        code.encode(chunks, out, indices);
        ArrayList<byte[]> ret = new ArrayList<byte[]>(numChecksums);
        for (Buffer buf : out) {
            ret.add(buf.b);
        }
        return ret;
    }

    @Override
    public byte[] decode(List<byte[]> packets, int size) {
        if (this.fecFactory == null) {
            this.fecFactory = FECCodeFactory.getDefault();
        }
        int packetSize = -1;
        ArrayList<Integer> indices = new ArrayList<Integer>(packets.size());
        ArrayList<Buffer> buffers = new ArrayList<Buffer>(packets.size());
        for (int i = 0; i < packets.size(); ++i) {
            if (packets.get(i) == null) continue;
            buffers.add(new Buffer(packets.get(i)));
            indices.add(i);
            if (packetSize == -1) {
                packetSize = packets.get(i).length;
                continue;
            }
            if (packets.get(i).length == packetSize) continue;
            return null;
        }
        if (packetSize == -1) {
            return null;
        }
        int[] indicesArray = new int[indices.size()];
        for (int i = 0; i < indicesArray.length; ++i) {
            indicesArray[i] = (Integer)indices.get(i);
        }
        Buffer[] bufferArray = new Buffer[buffers.size()];
        buffers.toArray(bufferArray);
        int numPackets = size / packetSize + (size % packetSize == 0 ? 0 : 1);
        FECCode code = this.fecFactory.createFECCode(numPackets, packets.size());
        try {
            code.decode(bufferArray, indicesArray);
        }
        catch (Throwable decodeFailed) {
            return null;
        }
        byte[] ret = new byte[size];
        for (int i = 0; i < numPackets; ++i) {
            byte[] b = bufferArray[i].b;
            System.arraycopy(b, 0, ret, i * packetSize, Math.min(packetSize, size - i * packetSize));
        }
        return ret;
    }
}

