/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.settings.URLHandlerSettings;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.LimeProcess;
import com.limegroup.gnutella.util.PackagedMediaFileUtils;
import com.limegroup.gnutella.util.QuotedStringTokenizer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.SystemUtils;

public final class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _openURL;

    private Launcher() {
    }

    public static int openURL(String url) throws IOException {
        if (OSUtils.isWindows()) {
            return Launcher.openURLWindows(url);
        }
        if (OSUtils.isMacOSX()) {
            Launcher.openURLMac(url);
        } else {
            Launcher.launchFileOther(url);
        }
        return -1;
    }

    private static int openURLWindows(String url) throws IOException {
        return SystemUtils.openURL(url);
    }

    private static void openURLMac(String url) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] params = new Object[]{url};
            _openURL.invoke(null, params);
        }
        catch (NoSuchMethodError err) {
            throw new IOException();
        }
        catch (NoClassDefFoundError err) {
            throw new IOException();
        }
        catch (IllegalAccessException iae) {
            throw new IOException();
        }
        catch (InvocationTargetException ite) {
            throw new IOException();
        }
    }

    public static LimeProcess launchFile(File file) throws IOException, SecurityException {
        String path = file.getCanonicalPath();
        String extCheckString = path.toLowerCase();
        if (extCheckString.endsWith(".pmf")) {
            if ((file = PackagedMediaFileUtils.preparePMFFile(file.toString())) == null) {
                throw new IOException("Invalid file");
            }
            path = file.getCanonicalPath();
            extCheckString = path.toLowerCase();
        }
        if (!(extCheckString.endsWith(".exe") || extCheckString.endsWith(".vbs") || extCheckString.endsWith(".lnk") || extCheckString.endsWith(".bat") || extCheckString.endsWith(".sys") || extCheckString.endsWith(".com"))) {
            if (OSUtils.isWindows()) {
                Launcher.launchFileWindows(path);
                return null;
            }
            if (OSUtils.isMacOSX()) {
                return Launcher.launchFileMacOSX(path);
            }
            return Launcher.launchFileOther(path);
        }
        throw new SecurityException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LimeProcess launchExplorer(File file) throws IOException, SecurityException {
        if (OSUtils.isWindows()) {
            String explorePath = file.getPath();
            try {
                explorePath = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!file.isDirectory()) return LimeProcess.exec(new String[]{"explorer", "/select,", explorePath});
            LimeProcess.exec(new String[]{"explorer", explorePath});
            return null;
        }
        if (!OSUtils.isMacOSX()) return null;
        return LimeProcess.exec(Launcher.selectFileCommand(file));
    }

    private static int launchFileWindows(String path) throws IOException {
        try {
            return SystemUtils.openFile(path);
        }
        catch (IOException iox) {
            throw new LaunchException(iox, path);
        }
    }

    private static LimeProcess launchFileMacOSX(String file) throws IOException {
        return LimeProcess.exec(new String[]{"open", file});
    }

    private static String[] selectFileCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            path = file.getAbsolutePath();
        }
        String[] command = new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "activate", "-e", "select hfsPath", "-e", "end tell"};
        return command;
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> mrjAdapter = Class.forName("net.roydesign.mac.MRJAdapter");
            _openURL = mrjAdapter.getDeclaredMethod("openURL", String.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException();
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException();
        }
        catch (SecurityException se) {
            throw new IOException();
        }
    }

    private static LimeProcess launchFileOther(String path) throws IOException {
        String handler = MediaType.getAudioMediaType().matches(path) ? URLHandlerSettings.AUDIO_PLAYER.getValue() : (MediaType.getVideoMediaType().matches(path) ? URLHandlerSettings.VIDEO_PLAYER.getValue() : (MediaType.getImageMediaType().matches(path) ? URLHandlerSettings.IMAGE_VIEWER.getValue() : URLHandlerSettings.BROWSER.getValue()));
        QuotedStringTokenizer tok = new QuotedStringTokenizer(handler);
        String[] strs = new String[tok.countTokens()];
        for (int i = 0; i < strs.length; ++i) {
            strs[i] = StringUtils.replace(tok.nextToken(), "$URL$", path);
        }
        return LimeProcess.exec(strs);
    }

    static {
        if (OSUtils.isMacOSX()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException ioe) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

