/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.downloader.InNetworkDownloader;
import com.limegroup.gnutella.downloader.ManagedDownloader;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.library.SharingUtils;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateCollectionFactory;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.version.UpdateHandler;
import com.limegroup.gnutella.version.UpdateInformation;
import com.limegroup.gnutella.version.UpdateMessageVerifier;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.io.Connectable;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UpdateHandlerImpl
implements UpdateHandler {
    private static final Log LOG = LogFactory.getLog(UpdateHandlerImpl.class);
    private static final long THREE_DAYS = 259200000L;
    private static final long ONE_MONTH = 2592000000L;
    private static final String FILENAME = "version.xml";
    private static final int IGNORE_ID = Integer.MAX_VALUE;
    private static final Random RANDOM = new Random();
    private final Clock clock;
    private volatile UpdateInformation _updateInfo;
    private volatile List<DownloadInformation> _updatesToDownload;
    private volatile int _lastId;
    private volatile byte[] _lastBytes;
    private long _lastTimestamp;
    private long _nextDownloadTime;
    private boolean _killingObsoleteNecessary;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<ActivityCallback> activityCallback;
    private final ConnectionServices connectionServices;
    private final Provider<HttpExecutor> httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<FileManager> fileManager;
    private final ApplicationServices applicationServices;
    private final UpdateCollectionFactory updateCollectionFactory;
    private final UpdateMessageVerifier updateMessageVerifier;
    private final RemoteFileDescFactory remoteFileDescFactory;
    private volatile String timeoutUpdateLocation = "http://update0.limewire.com/update.def";
    private volatile List<String> maxedUpdateList = Arrays.asList("http://update1.limewire.com/update.def", "http://update2.limewire.com/update.def", "http://update3.limewire.com/update.def", "http://update4.limewire.com/update.def", "http://update5.limewire.com/update.def", "http://update6.limewire.com/update.def", "http://update7.limewire.com/update.def", "http://update8.limewire.com/update.def", "http://update9.limewire.com/update.def", "http://update10.limewire.com/update.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;

    @Inject
    UpdateHandlerImpl(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<ActivityCallback> activityCallback, ConnectionServices connectionServices, Provider<HttpExecutor> httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker, CapabilitiesVMFactory capabilitiesVMFactory, Provider<ConnectionManager> connectionManager, Provider<DownloadManager> downloadManager, Provider<FileManager> fileManager, ApplicationServices applicationServices, UpdateCollectionFactory updateCollectionFactory, Clock clock, UpdateMessageVerifier updateMessageVerifier, RemoteFileDescFactory remoteFileDescFactory) {
        this.backgroundExecutor = backgroundExecutor;
        this.activityCallback = activityCallback;
        this.connectionServices = connectionServices;
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionManager = connectionManager;
        this.downloadManager = downloadManager;
        this.fileManager = fileManager;
        this.applicationServices = applicationServices;
        this.updateCollectionFactory = updateCollectionFactory;
        this.clock = clock;
        this.updateMessageVerifier = updateMessageVerifier;
        this.remoteFileDescFactory = remoteFileDescFactory;
    }

    String getTimeoutUrl() {
        return this.timeoutUpdateLocation;
    }

    void setTimeoutUrl(String url) {
        this.timeoutUpdateLocation = url;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> urls) {
        this.maxedUpdateList = urls;
    }

    int getMinHttpRequestUpdateDelayForMaxFailover() {
        return this.minMaxHttpRequestDelay;
    }

    int getMaxHttpRequestUpdateDelayForMaxFailover() {
        return this.maxMaxHttpRequestDelay;
    }

    void setMinHttpRequestUpdateDelayForMaxFailover(int min) {
        this.minMaxHttpRequestDelay = min;
    }

    void setMaxHttpRequestUpdateDelayForMaxFailover(int max) {
        this.maxMaxHttpRequestDelay = max;
    }

    int getSilentPeriodForMaxHttpRequest() {
        return this.silentPeriodForMaxHttpRequest;
    }

    void setSilentPeriodForMaxHttpRequest(int silentPeriodForMaxHttpRequest) {
        this.silentPeriodForMaxHttpRequest = silentPeriodForMaxHttpRequest;
    }

    @Override
    public void initialize() {
        LOG.trace("Initializing UpdateHandler");
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                UpdateHandlerImpl.this.handleDataInternal(FileUtils.readFileFully(UpdateHandlerImpl.this.getStoredFile()), UpdateType.FROM_DISK, null);
            }
        });
        this.backgroundExecutor.schedule(new Poller(), UpdateSettings.UPDATE_RETRY_DELAY.getValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void tryToDownloadUpdates() {
    }

    @Override
    public void handleUpdateAvailable(final ReplyHandler rh, final int version) {
        if (version == this._lastId) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    UpdateHandlerImpl.this.addSourceIfIdMatches(rh, version);
                }
            });
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version from rh: " + rh + ", them: " + version + ", me: " + this._lastId);
        }
    }

    @Override
    public void handleNewData(final byte[] data, final ReplyHandler handler) {
        if (data != null) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(data, UpdateType.FROM_NETWORK, handler);
                }
            });
        }
    }

    @Override
    public int getLatestId() {
        return this._lastId;
    }

    @Override
    public byte[] getLatestBytes() {
        return this._lastBytes;
    }

    private void handleDataInternal(byte[] data, UpdateType updateType, ReplyHandler handler) {
        if (data == null) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("No data to handle.");
            return;
        }
        String xml = this.updateMessageVerifier.getVerifiedData(data);
        if (xml == null) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
            }
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        if (updateType == UpdateType.FROM_NETWORK && handler != null) {
            this.networkUpdateSanityChecker.get().handleValidResponse(handler, NetworkUpdateSanityChecker.RequestType.VERSION);
        }
        UpdateCollection uc = this.updateCollectionFactory.createUpdateCollection(xml);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got a collection with id: " + uc.getId() + ", from " + (Object)((Object)updateType) + ".  Current id is: " + this._lastId);
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (uc.getId() == Integer.MAX_VALUE) {
                    if (this._lastId == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover(uc);
                    break;
                }
                if (uc.getId() <= this._lastId) {
                    this.checkForStaleUpdateAndMaybeDoHttpFailover(uc);
                    this.addSourceIfIdMatches(handler, uc.getId());
                    break;
                }
                this.storeAndUpdate(data, uc, updateType);
                break;
            }
            case FROM_DISK: {
                this.checkForStaleUpdateAndMaybeDoHttpFailover(uc);
                if (uc.getId() <= this._lastId) break;
                this.storeAndUpdate(data, uc, updateType);
                break;
            }
            case FROM_HTTP: {
                if (uc.getId() < this._lastId) break;
                this.storeAndUpdate(data, uc, updateType);
            }
        }
    }

    private void storeAndUpdate(byte[] data, UpdateCollection uc, UpdateType updateType) {
        Version limeV;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating.");
        }
        if (uc.getId() == Integer.MAX_VALUE && updateType == UpdateType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == UpdateType.FROM_NETWORK && this.httpRequestControl.isRequestPending() && this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.MAX) {
            return;
        }
        this._lastId = uc.getId();
        this._lastTimestamp = uc.getTimestamp();
        UpdateSettings.LAST_UPDATE_TIMESTAMP.setValue(this._lastTimestamp);
        long delay = UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue();
        long random = Math.abs(RANDOM.nextLong() % delay);
        this._nextDownloadTime = this._lastTimestamp + random;
        this._lastBytes = data;
        if (updateType != UpdateType.FROM_DISK) {
            if (this.httpRequestControl.getRequestReason() == HttpRequestControl.RequestReason.TIMEOUT) {
                this.httpRequestControl.cancelRequest();
            }
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(this.clock.now());
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
            this.capabilitiesVMFactory.updateCapabilities();
            this.connectionManager.get().sendUpdatedCapabilities();
        }
        try {
            limeV = new Version(LimeWireUtils.getLimeWireVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid LimeWire version", vfe);
            return;
        }
        Version javaV = null;
        try {
            javaV = new Version(VersionUtils.getJavaVersion());
        }
        catch (VersionFormatException vfe) {
            LOG.warn("Invalid java version", vfe);
        }
        int style = Math.min(2, UpdateSettings.UPDATE_STYLE.getValue());
        UpdateData updateInfo = uc.getUpdateDataFor(limeV, ApplicationSettings.getLanguage(), LimeWireUtils.isPro(), style, javaV);
        List<DownloadInformation> updatesToDownload = uc.getUpdatesWithDownloadInformation();
        this._killingObsoleteNecessary = true;
        if (updateInfo != null && updateInfo.getUpdateURN() != null) {
            UpdateHandlerImpl.prepareUpdateCommand(updateInfo);
            updatesToDownload = new LinkedList<DownloadInformation>(updatesToDownload);
            updatesToDownload.add(0, updateInfo);
        }
        this._updateInfo = updateInfo;
        this._updatesToDownload = updatesToDownload;
        this.downloadUpdates(updatesToDownload, null);
        if (updateInfo == null) {
            LOG.warn("No relevant update info to notify about.");
            return;
        }
        if (updateInfo.getUpdateURN() == null || UpdateHandlerImpl.isHopeless(updateInfo)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("we have an update, but it doesn't need a download.  or all our updates are hopeles. Scheduling URL notification...");
            }
            updateInfo.setUpdateCommand(null);
            this.backgroundExecutor.schedule(new NotificationFailover(this._lastId), UpdateHandlerImpl.delay(this.clock.now(), uc.getTimestamp()), TimeUnit.MILLISECONDS);
        } else if (this.isMyUpdateDownloaded(updateInfo)) {
            LOG.debug("there is an update for me, but I happen to have it on disk");
            this.activityCallback.get().updateAvailable(updateInfo);
        } else {
            LOG.debug("we have an update, it needs a download.  Rely on callbacks");
        }
    }

    private void checkForStaleUpdateAndMaybeDoHttpFailover(UpdateCollection uc) {
        LOG.debug("checking for timeout http failover");
        long monthAgo = this.clock.now() - 2592000000L;
        if (UpdateSettings.LAST_UPDATE_TIMESTAMP.getValue() < monthAgo && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < monthAgo && !this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.TIMEOUT)) {
            long when = (this.connectionServices.isConnected() ? 1 : 5) * 60 * 1000;
            if (LOG.isDebugEnabled()) {
                LOG.debug("scheduling http failover in " + when);
            }
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(UpdateHandlerImpl.this.timeoutUpdateLocation);
                    }
                    catch (URISyntaxException e) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(e.toString(), e);
                    }
                }
            }, when, TimeUnit.MILLISECONDS);
        }
    }

    private void doHttpMaxFailover(UpdateCollection updateCollection) {
        long maxTimeAgo = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX) && UpdateSettings.LAST_HTTP_FAILOVER.getValue() < maxTimeAgo) {
            LOG.debug("Scheduling http max failover...");
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    String url = (String)UpdateHandlerImpl.this.maxedUpdateList.get(RANDOM.nextInt(UpdateHandlerImpl.this.maxedUpdateList.size()));
                    try {
                        UpdateHandlerImpl.this.launchHTTPUpdate(url);
                    }
                    catch (URISyntaxException e) {
                        UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                        UpdateHandlerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn(e.toString(), e);
                    }
                }
            }, (long)(RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay), TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String url) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet get = new HttpGet(LimeWireUtils.addLWInfoToUrl(url, this.applicationServices.getMyGUID()));
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(get, params, new RequestHandler());
    }

    private static void prepareUpdateCommand(UpdateData info) {
        if (info == null || info.getUpdateCommand() == null) {
            return;
        }
        File path = SharingUtils.PREFERENCE_SHARE.getAbsoluteFile();
        String name = info.getUpdateFileName();
        try {
            path = FileUtils.getCanonicalFile(path);
        }
        catch (IOException bad) {
            // empty catch block
        }
        String command = info.getUpdateCommand();
        command = StringUtils.replace(command, "$", path.getPath() + File.separator);
        command = StringUtils.replace(command, "%", name);
        info.setUpdateCommand(command);
    }

    private static boolean isHopeless(DownloadInformation info) {
        return UpdateSettings.FAILED_UPDATES.contains(info.getUpdateURN().httpStringValue());
    }

    private void addSourceIfIdMatches(ReplyHandler rh, int version) {
        if (version == this._lastId) {
            this.downloadUpdates(this._updatesToDownload, rh);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Another version? Me: " + version + ", here: " + this._lastId);
        }
    }

    private void downloadUpdates(List<? extends DownloadInformation> toDownload, ReplyHandler source) {
        if (toDownload == null) {
            toDownload = Collections.emptyList();
        }
        this.killObsoleteUpdates(toDownload);
        for (DownloadInformation next : toDownload) {
            if (UpdateHandlerImpl.isHopeless(next) || !this.downloadManager.get().isSavedDownloadsLoaded() || !this.fileManager.get().isLoadFinished()) continue;
            FileDesc shared = this.fileManager.get().getFileDescForUrn(next.getUpdateURN());
            ManagedDownloader md = (ManagedDownloader)this.downloadManager.get().getDownloaderForURN(next.getUpdateURN());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking for: " + next + ", got: " + shared);
            }
            if (shared != null && shared.getClass() == FileDesc.class) {
                if (md == null) continue;
                md.stop();
                continue;
            }
            if (md == null && !this.downloadManager.get().hasInNetworkDownload() && this.canStartDownload()) {
                LOG.debug("Starting a new InNetwork Download");
                try {
                    md = (ManagedDownloader)this.downloadManager.get().download(next, this.clock.now());
                }
                catch (SaveLocationException sle) {
                    LOG.error("Unable to construct download", sle);
                }
            }
            if (md == null) continue;
            if (source != null) {
                md.addDownload(this.rfd(source, next), false);
                continue;
            }
            this.addCurrentDownloadSources(md, next);
        }
    }

    private void killObsoleteUpdates(List<? extends DownloadInformation> toDownload) {
        if (!this.downloadManager.get().isSavedDownloadsLoaded() || !this.fileManager.get().isLoadFinished()) {
            return;
        }
        if (this._killingObsoleteNecessary) {
            this._killingObsoleteNecessary = false;
            this.downloadManager.get().killDownloadersNotListed(toDownload);
            HashSet<URN> urns = new HashSet<URN>(toDownload.size());
            for (DownloadInformation downloadInformation : toDownload) {
                urns.add(downloadInformation.getUpdateURN());
            }
            List<FileDesc> shared = this.fileManager.get().getSharedFilesInDirectory(SharingUtils.PREFERENCE_SHARE);
            for (FileDesc fd : shared) {
                if (fd.getSHA1Urn() == null || urns.contains(fd.getSHA1Urn())) continue;
                this.fileManager.get().removeFileIfShared(fd.getFile());
                fd.getFile().delete();
            }
        }
    }

    private void addCurrentDownloadSources(ManagedDownloader md, DownloadInformation info) {
        for (RoutedConnection mc : this.connectionManager.get().getConnections()) {
            if (mc.getConnectionCapabilities().getRemoteHostUpdateVersion() == this._lastId) {
                LOG.debug("Adding source: " + mc);
                md.addDownload(this.rfd(mc, info), false);
                continue;
            }
            LOG.debug("Not adding source because bad id: " + mc.getConnectionCapabilities().getRemoteHostUpdateVersion() + ", us: " + this._lastId);
        }
    }

    private RemoteFileDesc rfd(ReplyHandler rh, DownloadInformation info) {
        UrnSet urns = new UrnSet(info.getUpdateURN());
        return this.remoteFileDescFactory.createRemoteFileDesc(rh.getAddress(), rh.getPort(), Integer.MAX_VALUE, info.getUpdateFileName(), (int)info.getSize(), rh.getClientGUID(), 0, false, 2, false, null, urns, false, false, "LIME", IpPort.EMPTY_SET, 0L, 0, rh instanceof Connectable ? ((Connectable)((Object)rh)).isTLSCapable() : false);
    }

    private boolean canStartDownload() {
        long now = this.clock.now();
        if (LOG.isDebugEnabled()) {
            LOG.debug("now is " + now + " next time is " + this._nextDownloadTime);
        }
        return now > this._nextDownloadTime;
    }

    private void notifyAboutInfo(int id) {
        if (id != this._lastId) {
            return;
        }
        UpdateInformation update = this._updateInfo;
        assert (update != null);
        this.activityCallback.get().updateAvailable(update);
    }

    private static long delay(long now, long timestamp) {
        if (timestamp - now > 259200000L) {
            return 0L;
        }
        long delay = UpdateSettings.UPDATE_DELAY.getValue();
        long random = Math.abs(new Random().nextLong() % delay);
        long then = timestamp + random;
        if (LOG.isInfoEnabled()) {
            LOG.info("Delaying Update.\nNow    : " + now + "\nStamp  : " + timestamp + "\nDelay  : " + delay + "\nRandom : " + random + "\nThen   : " + then + "\nDiff   : " + (then - now));
        }
        return Math.max(0L, then - now);
    }

    @Override
    public void inNetworkDownloadFinished(final URN urn, final boolean good) {
        Runnable r = new Runnable(){

            public void run() {
                UpdateData updateInfo;
                if (!good) {
                    UpdateSettings.FAILED_UPDATES.add(urn.httpStringValue());
                }
                if ((updateInfo = (UpdateData)UpdateHandlerImpl.this._updateInfo) != null && updateInfo.getUpdateURN() != null && updateInfo.getUpdateURN().equals(urn)) {
                    if (!good) {
                        updateInfo.setUpdateCommand(null);
                        long delay = UpdateHandlerImpl.delay(UpdateHandlerImpl.this.clock.now(), UpdateHandlerImpl.this._lastTimestamp);
                        UpdateHandlerImpl.this.backgroundExecutor.schedule(new NotificationFailover(UpdateHandlerImpl.this._lastId), delay, TimeUnit.MILLISECONDS);
                    } else {
                        ((ActivityCallback)UpdateHandlerImpl.this.activityCallback.get()).updateAvailable(updateInfo);
                        ((ConnectionManager)UpdateHandlerImpl.this.connectionManager.get()).sendUpdatedCapabilities();
                    }
                }
            }
        };
        this.backgroundExecutor.execute(r);
    }

    private void killHopelessUpdates(List<? extends DownloadInformation> updates) {
        if (updates == null) {
            return;
        }
        if (!this.downloadManager.get().hasInNetworkDownload()) {
            return;
        }
        long now = this.clock.now();
        for (DownloadInformation downloadInformation : updates) {
            InNetworkDownloader iDownloader;
            Downloader downloader = this.downloadManager.get().getDownloaderForURN(downloadInformation.getUpdateURN());
            if (downloader == null || !(downloader instanceof InNetworkDownloader) || !this.isHopeless(iDownloader = (InNetworkDownloader)downloader, now)) continue;
            iDownloader.stop();
        }
    }

    private boolean isHopeless(InNetworkDownloader downloader, long now) {
        if (now - downloader.getStartTime() < (long)UpdateSettings.UPDATE_GIVEUP_FACTOR.getValue() * UpdateSettings.UPDATE_DOWNLOAD_DELAY.getValue()) {
            return false;
        }
        return downloader.getDownloadAttempts() >= UpdateSettings.UPDATE_MIN_ATTEMPTS.getValue();
    }

    private boolean isMyUpdateDownloaded(UpdateInformation myInfo) {
        if (!this.fileManager.get().isLoadFinished()) {
            return false;
        }
        URN myUrn = myInfo.getUpdateURN();
        if (myUrn == null) {
            return true;
        }
        FileDesc desc = this.fileManager.get().getFileDescForUrn(myUrn);
        if (desc == null) {
            return false;
        }
        return desc.getClass() == FileDesc.class;
    }

    private File getStoredFile() {
        return new File(CommonUtils.getUserSettingsDir(), FILENAME);
    }

    static /* synthetic */ boolean access$500(UpdateHandlerImpl x0, UpdateInformation x1) {
        return x0.isMyUpdateDownloaded(x1);
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason reason) {
            boolean prior = this.requestQueued.getAndSet(true);
            if (!prior || reason == RequestReason.MAX) {
                this.requestReason = reason;
            }
            return prior || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum RequestReason {
            TIMEOUT,
            MAX;

        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            byte[] inflated;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            try {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + response.getStatusLine().getStatusCode());
                }
                byte[] resp = null;
                if (response.getEntity() != null) {
                    resp = IOUtils.readFully(response.getEntity().getContent());
                }
                if (resp == null || resp.length == 0) {
                    throw new IOException("bad body");
                }
                inflated = UpdateHandlerImpl.this.updateMessageVerifier.inflateNetworkData(resp);
            }
            catch (IOException failed) {
                UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", failed);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            }
            UpdateHandlerImpl.this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    UpdateHandlerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace("Parsing new data...");
                    UpdateHandlerImpl.this.handleDataInternal(inflated, UpdateType.FROM_HTTP, null);
                }
            });
            return false;
        }

        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("http failover failed", exc);
            UpdateHandlerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_HTTP_FAILOVER.setValue(UpdateHandlerImpl.this.clock.now());
            ((HttpExecutor)UpdateHandlerImpl.this.httpExecutor.get()).releaseResources(response);
            return false;
        }
    }

    private class NotificationFailover
    implements Runnable {
        private final int id;
        private boolean shown;

        NotificationFailover(int id) {
            this.id = id;
        }

        public void run() {
            if (this.shown) {
                return;
            }
            this.shown = true;
            UpdateHandlerImpl.this.notifyAboutInfo(this.id);
        }
    }

    private class Poller
    implements Runnable {
        private Poller() {
        }

        public void run() {
            UpdateHandlerImpl.this.downloadUpdates(UpdateHandlerImpl.this._updatesToDownload, null);
            UpdateHandlerImpl.this.killHopelessUpdates(UpdateHandlerImpl.this._updatesToDownload);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateType {
        FROM_NETWORK,
        FROM_DISK,
        FROM_HTTP;

    }
}

