/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class LimeXMLDocumentHelper {
    private static final Log LOG = LogFactory.getLog(LimeXMLDocumentHelper.class);
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String XML_NAMESPACE = "xsi:noNamespaceSchemaLocation=\"";
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    @Inject
    public LimeXMLDocumentHelper(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
    }

    public List<LimeXMLDocument[]> getDocuments(String aggregatedXML, int totalResponseCount) {
        if (aggregatedXML == null || aggregatedXML.equals("") || totalResponseCount <= 0) {
            return Collections.emptyList();
        }
        ArrayList<LimeXMLDocument[]> results = new ArrayList<LimeXMLDocument[]>();
        for (String xmlDocument : XMLParsingUtils.split(aggregatedXML)) {
            XMLParsingUtils.ParseResult parsingResult;
            try {
                parsingResult = XMLParsingUtils.parse(xmlDocument, totalResponseCount);
            }
            catch (SAXException sax) {
                LOG.warn("SAX while parsing: " + xmlDocument, sax);
                continue;
            }
            catch (IOException bad) {
                LOG.warn("IOX while parsing: " + aggregatedXML, bad);
                return Collections.emptyList();
            }
            String indexKey = parsingResult.canonicalKeyPrefix + "index__";
            LimeXMLDocument[] documents = new LimeXMLDocument[totalResponseCount];
            for (Map attributes : parsingResult) {
                String sindex = (String)attributes.remove(indexKey);
                if (sindex == null) {
                    return Collections.emptyList();
                }
                int index = -1;
                try {
                    index = Integer.parseInt(sindex);
                }
                catch (NumberFormatException bad) {
                    LOG.warn("NFE while parsing", bad);
                    return Collections.emptyList();
                }
                if (index >= documents.length || index < 0) {
                    return Collections.emptyList();
                }
                if (attributes.isEmpty()) continue;
                try {
                    documents[index] = this.limeXMLDocumentFactory.createLimeXMLDocument(attributes, parsingResult.schemaURI, parsingResult.canonicalKeyPrefix);
                }
                catch (IOException ignored) {
                    LOG.debug("", ignored);
                }
            }
            results.add(documents);
        }
        return results;
    }

    public static String getAggregateString(Response[] responses) {
        HashMap<LimeXMLSchema, StringBuilder> allXML = new HashMap<LimeXMLSchema, StringBuilder>();
        for (int i = 0; i < responses.length; ++i) {
            LimeXMLDocument doc = responses[i].getDocument();
            if (doc == null) continue;
            LimeXMLSchema schema = doc.getSchema();
            StringBuilder built = (StringBuilder)allXML.get(schema);
            if (built == null) {
                built = new StringBuilder();
                allXML.put(schema, built);
            }
            built.append(doc.getAttributeStringWithIndex(i));
        }
        StringBuilder fullXML = new StringBuilder();
        for (Map.Entry entry : allXML.entrySet()) {
            LimeXMLDocumentHelper.buildXML(fullXML, (LimeXMLSchema)entry.getKey(), ((StringBuilder)entry.getValue()).toString());
        }
        return fullXML.toString();
    }

    public static void buildXML(StringBuilder buffer, LimeXMLSchema schema, String inner) {
        buffer.append(XML_HEADER);
        buffer.append("<");
        buffer.append(schema.getRootXMLName());
        buffer.append(" ");
        buffer.append(XML_NAMESPACE);
        buffer.append(schema.getSchemaURI());
        buffer.append("\">");
        buffer.append(inner);
        buffer.append("</");
        buffer.append(schema.getRootXMLName());
        buffer.append(">");
    }
}

