/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeXMLSchemaRepository {
    private Map<String, LimeXMLSchema> _uriSchemaMap = new HashMap<String, LimeXMLSchema>();

    @Inject
    LimeXMLSchemaRepository(LimeXMLProperties limeXMLProperties) {
        URL[] schemaUrls = limeXMLProperties.getAllXmlSchemaUrls();
        for (int i = 0; i < schemaUrls.length; ++i) {
            if (schemaUrls[i] == null) continue;
            try {
                LimeXMLSchema limeXmlSchema = new LimeXMLSchema(schemaUrls[i]);
                this._uriSchemaMap.put(limeXmlSchema.getSchemaURI(), limeXmlSchema);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLSchema getSchema(String uri) {
        Map<String, LimeXMLSchema> map = this._uriSchemaMap;
        synchronized (map) {
            return this._uriSchemaMap.get(uri);
        }
    }

    public Collection<LimeXMLSchema> getAvailableSchemas() {
        return Collections.unmodifiableCollection(this._uriSchemaMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAvailableSchemaURIs() {
        Object[] schemaURIs;
        Map<String, LimeXMLSchema> map = this._uriSchemaMap;
        synchronized (map) {
            schemaURIs = this._uriSchemaMap.keySet().toArray(new String[0]);
        }
        Arrays.sort(schemaURIs);
        return schemaURIs;
    }
}

