/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerController;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.FileManagerImpl;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class MetaFileManager
extends FileManagerImpl {
    private static final Log LOG = LogFactory.getLog(MetaFileManager.class);
    private Saver saver;

    @Inject
    public MetaFileManager(FileManagerController fileManagerController) {
        super(fileManagerController);
    }

    @Override
    public synchronized Response[] query(QueryRequest request) {
        Response[] metas;
        LimeXMLDocument doc;
        Response[] result = super.query(request);
        if (this.shouldIncludeXMLInResponse(request) && (doc = request.getRichQuery()) != null && (metas = this.query(doc)) != null) {
            result = this.union(result, metas, doc);
        }
        return result;
    }

    @Override
    protected boolean isValidXMLMatch(Response r, LimeXMLDocument doc) {
        return LimeXMLUtils.match(r.getDocument(), doc, true);
    }

    @Override
    protected boolean shouldIncludeXMLInResponse(QueryRequest qr) {
        return qr.desiresXMLResponses() || qr.desiresOutOfBandReplies();
    }

    @Override
    protected void addXMLToResponse(Response response, FileDesc fd) {
        List<LimeXMLDocument> docs = fd.getLimeXMLDocuments();
        if (docs.size() == 0) {
            return;
        }
        if (docs.size() == 1) {
            response.setDocument(docs.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File f) {
        FileDesc fd;
        if (LOG.isTraceEnabled()) {
            LOG.debug("File Changed: " + f);
        }
        if ((fd = this.getFileDescForFile(f)) == null) {
            return;
        }
        final Long cTime = this.fileManagerController.getCreationTime(fd.getSHA1Urn());
        List<LimeXMLDocument> xmlDocs = fd.getLimeXMLDocuments();
        if (LimeXMLUtils.isEditableFormat(f)) {
            try {
                LimeXMLDocument diskDoc = this.fileManagerController.readDocument(f);
                xmlDocs = this.resolveWriteableDocs(xmlDocs, diskDoc);
            }
            catch (IOException e) {
                xmlDocs = Collections.emptyList();
            }
        }
        final FileDesc removed = this.removeFileIfShared(f, false);
        assert (fd == removed) : "wanted to remove: " + fd + "\ndid remove: " + removed;
        MetaFileManager metaFileManager = this;
        synchronized (metaFileManager) {
            _needRebuild = true;
        }
        this.addFileIfSharedOrStore(f, xmlDocs, false, this._revision, new FileEventListener(){

            public void handleFileEvent(FileManagerEvent evt) {
                FileManagerEvent newEvt = null;
                if (evt.isAddEvent()) {
                    FileDesc fd = evt.getFileDescs()[0];
                    MetaFileManager.this.fileManagerController.fileChanged(fd.getSHA1Urn(), cTime);
                    newEvt = new FileManagerEvent((FileManager)MetaFileManager.this, FileManagerEvent.Type.CHANGE_FILE, removed, fd);
                } else {
                    newEvt = new FileManagerEvent((FileManager)MetaFileManager.this, FileManagerEvent.Type.REMOVE_FILE, removed);
                }
                MetaFileManager.this.dispatchFileEvent(newEvt);
            }
        }, FileManagerImpl.AddType.ADD_SHARE);
    }

    private List<LimeXMLDocument> resolveWriteableDocs(List<LimeXMLDocument> allDocs, LimeXMLDocument id3Doc) {
        LimeXMLDocument audioDoc = null;
        LimeXMLSchema audioSchema = this.fileManagerController.getSchema("http://www.limewire.com/schemas/audio.xsd");
        for (LimeXMLDocument doc : allDocs) {
            if (doc.getSchema() != audioSchema) continue;
            audioDoc = doc;
            break;
        }
        if (id3Doc.equals(audioDoc)) {
            return allDocs;
        }
        ArrayList<LimeXMLDocument> retList = new ArrayList<LimeXMLDocument>();
        retList.addAll(allDocs);
        if (audioDoc == null) {
            retList.add(id3Doc);
            return retList;
        }
        retList.remove(audioDoc);
        List<NameValue<String>> audioList = audioDoc.getOrderedNameValueList();
        List<NameValue<String>> id3List = id3Doc.getOrderedNameValueList();
        for (int i = 0; i < audioList.size(); ++i) {
            NameValue<String> nameVal = audioList.get(i);
            if (!AudioMetaData.isNonLimeAudioField(nameVal.getName())) continue;
            id3List.add(nameVal);
        }
        audioDoc = this.fileManagerController.createLimeXMLDocument(id3List, "http://www.limewire.com/schemas/audio.xsd");
        retList.add(audioDoc);
        return retList;
    }

    @Override
    protected synchronized FileDesc removeFileIfShared(File f, boolean notify) {
        FileDesc fd = super.removeFileIfShared(f, notify);
        if (fd == null) {
            return null;
        }
        List<LimeXMLDocument> xmlDocs = fd.getLimeXMLDocuments();
        LinkedList<String> schemas = new LinkedList<String>();
        for (LimeXMLDocument doc : xmlDocs) {
            schemas.add(doc.getSchemaURI());
        }
        for (String uri : schemas) {
            LimeXMLReplyCollection col = this.fileManagerController.getReplyCollection(uri);
            if (col == null) continue;
            col.removeDoc(fd);
        }
        _needRebuild = true;
        return fd;
    }

    @Override
    protected void loadStarted(int revision) {
        this.fileManagerController.setAnnotateEnabled(false);
        String[] schemas = this.fileManagerController.getAvailableSchemaURIs();
        for (int i = 0; i < schemas.length; ++i) {
            this.fileManagerController.add(schemas[i], this.fileManagerController.createLimeXMLReplyCollection(schemas[i]));
        }
        super.loadStarted(revision);
    }

    @Override
    protected void loadFinished(int revision) {
        if (this.saver == null) {
            this.saver = new Saver();
            this.fileManagerController.scheduleWithFixedDelay(this.saver, 60000, 60000, TimeUnit.MILLISECONDS);
        }
        Collection<LimeXMLReplyCollection> replies = this.fileManagerController.getCollections();
        for (LimeXMLReplyCollection col : replies) {
            col.loadFinished();
        }
        this.fileManagerController.setAnnotateEnabled(true);
        super.loadFinished(revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadFile(FileDesc fd, File file, List<? extends LimeXMLDocument> metadata, Set<? extends URN> urns) {
        super.loadFile(fd, file, metadata, urns);
        boolean added = false;
        Collection<LimeXMLReplyCollection> replies = this.fileManagerController.getCollections();
        for (LimeXMLReplyCollection col : replies) {
            added |= col.initialize(fd, metadata) != null;
        }
        for (LimeXMLReplyCollection col : replies) {
            added |= col.createIfNecessary(fd) != null;
        }
        if (added) {
            MetaFileManager metaFileManager = this;
            synchronized (metaFileManager) {
                _needRebuild = true;
            }
        }
    }

    @Override
    protected void save() {
        if (this.isLoadFinished()) {
            Collection<LimeXMLReplyCollection> replies = this.fileManagerController.getCollections();
            for (LimeXMLReplyCollection col : replies) {
                col.writeMapToDisk();
            }
        }
        super.save();
    }

    private Response[] union(Response[] normals, Response[] metas, LimeXMLDocument requested) {
        int i;
        if (normals == null || normals.length == 0) {
            return metas;
        }
        if (metas == null || metas.length == 0) {
            return normals;
        }
        HashSet<Response> unionSet = new HashSet<Response>();
        for (i = 0; i < metas.length; ++i) {
            unionSet.add(metas[i]);
        }
        for (i = 0; i < normals.length; ++i) {
            unionSet.add(normals[i]);
        }
        Response[] retArray = new Response[unionSet.size()];
        retArray = unionSet.toArray(retArray);
        return retArray;
    }

    @Override
    protected void buildQRT() {
        super.buildQRT();
        for (String string : this.getXMLKeyWords()) {
            _queryRouteTable.add(string);
        }
        for (String string : this.getXMLIndivisibleKeyWords()) {
            _queryRouteTable.addIndivisible(string);
        }
    }

    private List<String> getXMLKeyWords() {
        ArrayList<String> words = new ArrayList<String>();
        String[] schemas = this.fileManagerController.getAvailableSchemaURIs();
        int len = schemas.length;
        for (int i = 0; i < len; ++i) {
            LimeXMLReplyCollection collection = this.fileManagerController.getReplyCollection(schemas[i]);
            if (collection == null) continue;
            words.addAll(collection.getKeyWords());
        }
        return words;
    }

    private List<String> getXMLIndivisibleKeyWords() {
        ArrayList<String> words = new ArrayList<String>();
        String[] schemas = this.fileManagerController.getAvailableSchemaURIs();
        for (int i = 0; i < schemas.length; ++i) {
            LimeXMLReplyCollection collection;
            if (schemas[i] != null) {
                words.add(schemas[i]);
            }
            if ((collection = this.fileManagerController.getReplyCollection(schemas[i])) == null) continue;
            words.addAll(collection.getKeyWordsIndivisible());
        }
        return words;
    }

    private Response[] query(LimeXMLDocument queryDoc) {
        String schema = queryDoc.getSchemaURI();
        LimeXMLReplyCollection replyCol = this.fileManagerController.getReplyCollection(schema);
        if (replyCol == null) {
            return null;
        }
        List<LimeXMLDocument> matchingReplies = replyCol.getMatchingReplies(queryDoc);
        int s = matchingReplies.size();
        if (s == 0) {
            return null;
        }
        Response[] retResponses = new Response[s];
        int z = 0;
        for (LimeXMLDocument currDoc : matchingReplies) {
            File file = currDoc.getIdentifier();
            Response res = null;
            if (file == null) {
                res = this.fileManagerController.createPureMetadataResponse();
            } else {
                FileDesc fd = this.getFileDescForFile(file);
                if (fd == null || fd instanceof IncompleteFileDesc) continue;
                res = this.fileManagerController.createResponse(fd);
                fd.incrementHitCount();
                this.fileManagerController.handleSharedFileUpdate(fd.getFile());
            }
            res.setDocument(currDoc);
            retResponses[z] = res;
            ++z;
        }
        if (z == 0) {
            return null;
        }
        if (z < s) {
            Response[] temp = new Response[z];
            System.arraycopy(retResponses, 0, temp, 0, z);
            retResponses = temp;
        }
        return retResponses;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        public void run() {
            if (!MetaFileManager.this.shutdown && MetaFileManager.this.isLoadFinished()) {
                MetaFileManager.this.save();
            }
        }
    }
}

