/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.SoundHandler;
import java.util.Enumeration;
import java.util.Hashtable;

public class AudioConfiguration {
    private SoundHandler _sound;
    private String _query;
    private String _beep;
    private Hashtable _word;

    public AudioConfiguration(SoundHandler sound) {
        this._sound = sound;
        this._query = null;
        this._beep = null;
        this._word = new Hashtable();
    }

    public void play(String snd) {
        this._sound.playSound(snd);
    }

    public void setQuery(String snd) {
        this._query = snd;
    }

    public void setBeep(String snd) {
        this._beep = snd;
    }

    public void setWord(String word, String snd) {
        this._word.put(word, snd);
    }

    public void onQuery() {
        if (this._query != null) {
            this._sound.playSound(this._query);
        }
    }

    public void beep() {
        if (this._beep != null) {
            this._sound.playSound(this._beep);
        }
    }

    public void onWord(String word) {
        String snd = (String)this._word.get(word);
        if (snd != null) {
            this._sound.playSound(snd);
        }
    }

    public Enumeration getSoundWords() {
        return this._word.keys();
    }
}

