/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.RootInterpretor;
import irc.Server;
import irc.Source;
import java.util.Enumeration;

public class BasicInterpretor
extends RootInterpretor
implements Interpretor {
    public BasicInterpretor(IRCConfiguration config) {
        this(config, null);
    }

    public BasicInterpretor(IRCConfiguration config, Interpretor next) {
        super(config, next);
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        try {
            Server server = source.getServer();
            if (cmd.equals("echo")) {
                this.test(cmd, parts, 1);
                source.report(cumul[1]);
            } else if (cmd.equals("sleep")) {
                this.test(cmd, parts, 1);
                try {
                    int ms = new Integer(parts[1]);
                    Thread.sleep(ms);
                }
                catch (Exception ex) {}
            } else if (cmd.equals("me")) {
                this.test(cmd, parts, 1);
                this.sendString(source, "/ctcp action " + cumul[1]);
            } else if (cmd.equals("action")) {
                this.test(cmd, parts, 1);
                this.sendString(source, "/ctcp action " + cumul[1]);
            } else if (cmd.equals("play")) {
                this.test(cmd, parts, 1);
                this._ircConfiguration.getAudioConfiguration().play(parts[1]);
            } else if (cmd.equals("url")) {
                this.test(cmd, parts, 1);
                if (parts.length >= 3) {
                    this._ircConfiguration.getURLHandler().openURL(parts[1], parts[2]);
                } else {
                    this._ircConfiguration.getURLHandler().openURL(parts[1]);
                }
            } else if (cmd.equals("clear")) {
                source.clear();
            } else if (cmd.equals("leave")) {
                source.leave();
            } else if (cmd.equals("msg")) {
                this.test(cmd, parts, 2);
                boolean said = false;
                Enumeration e = server.getSources();
                while (e.hasMoreElements()) {
                    Source s = (Source)e.nextElement();
                    if (!s.getName().equals(parts[1])) continue;
                    this.say(s, cumul[2]);
                    said = true;
                }
                if (!said) {
                    server.say(parts[1], cumul[2]);
                }
            } else {
                super.handleCommand(source, cmd, parts, cumul);
            }
        }
        catch (NotEnoughParametersException ex) {
            source.report(" *** Invalid command format: " + ex.getMessage());
        }
    }
}

