/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.IRCConfiguration;
import irc.Interpretor;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.ServerManager;
import irc.Source;
import java.util.Date;
import java.util.Locale;

public class CTCPInterpretor
extends BasicInterpretor {
    protected ServerManager _mgr;

    public CTCPInterpretor(IRCConfiguration config, Interpretor next, ServerManager mgr) {
        super(config, next);
        this._mgr = mgr;
    }

    private void send(Server s, String destination, String msg) {
        s.say(destination, "\u0001" + msg + "\u0001");
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        try {
            if (cmd.equals("ctcp")) {
                this.test(cmd, parts, 1);
                if (parts[1].toLowerCase(Locale.ENGLISH).equals("ping")) {
                    this.test(cmd, parts, 2);
                    this.send(source.getServer(), parts[2], "PING " + new Date().getTime());
                } else if (parts[1].toLowerCase(Locale.ENGLISH).equals("action")) {
                    this.test(cmd, parts, 2);
                    if (source.talkable()) {
                        this.send(source.getServer(), source.getName(), "ACTION " + cumul[2]);
                        source.action(source.getServer().getNick(), cumul[2]);
                    } else {
                        source.report(" *** Your message cannot be sent.");
                    }
                } else if (parts[1].toLowerCase(Locale.ENGLISH).equals("raw")) {
                    this.test(cmd, parts, 3);
                    this.send(source.getServer(), parts[2], cumul[3]);
                } else {
                    this.test(cmd, parts, 2);
                    this.send(source.getServer(), parts[2], parts[1]);
                }
            } else {
                super.handleCommand(source, cmd, parts, cumul);
            }
        }
        catch (NotEnoughParametersException ex) {
            source.report(" *** Invalid command format: " + ex.getMessage());
        }
    }
}

