/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChanListListener;
import irc.ChannelInfo;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import java.util.Vector;

public class ChanList
extends IRCSource {
    private ListenerGroup _listeners;
    private Vector _channels;
    private String _name;
    private boolean _running;
    private int _ignored;

    public ChanList(IRCConfiguration config, IRCServer server, String name) {
        super(config, server);
        this._name = name;
        this._server = server;
        this._listeners = new ListenerGroup();
        this._channels = new Vector();
        this._running = false;
    }

    public String getType() {
        return "ChanList";
    }

    public String getName() {
        return this._name;
    }

    public ChannelInfo[] getChannels() {
        ChannelInfo[] ans = new ChannelInfo[this._channels.size()];
        for (int i = 0; i < this._channels.size(); ++i) {
            ans[i] = (ChannelInfo)this._channels.elementAt(i);
        }
        return ans;
    }

    public int getChannelCount() {
        return this._channels.size();
    }

    public int getIgnoredChannelCount() {
        return this._ignored;
    }

    public void addChannel(ChannelInfo nfo) {
        if (this._channels.size() > 1024 && nfo.userCount < 5) {
            ++this._ignored;
            return;
        }
        this._channels.insertElementAt(nfo, this._channels.size());
        this._listeners.sendEvent("channelAdded", nfo, this);
    }

    public void begin() {
        this._ignored = 0;
        this._running = true;
        this._channels = new Vector();
        this._listeners.sendEvent("channelBegin", this);
    }

    public void end() {
        this._running = false;
        this._listeners.sendEvent("channelEnd", this);
    }

    public void addChanListListener(ChanListListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeChanListListeners(ChanListListener lis) {
        this._listeners.removeListener(lis);
    }

    public void leave() {
        if (this._running) {
            return;
        }
        this.getIRCServer().leaveChanList(this._name);
    }

    public boolean talkable() {
        return false;
    }

    public boolean mayDefault() {
        return false;
    }
}

