/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.ChannelInterpretor;
import irc.ChannelListener;
import irc.ChannelListener2;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.IRCSource;
import irc.ListenerGroup;
import irc.ModeHandler;
import irc.Nick;
import irc.ReplyServerListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class Channel
extends IRCSource
implements ReplyServerListener {
    private String _name;
    private String _topic;
    private ModeHandler _mode;
    private ListenerGroup _listeners;
    private Hashtable _nicks;

    public Channel(IRCConfiguration config, String name, IRCServer s) {
        super(config, s);
        this._name = name;
        this._topic = "";
        this._mode = new ModeHandler(s.getChannelModes(), s.getNickModes());
        this._listeners = new ListenerGroup();
        this._nicks = new Hashtable();
        s.addReplyServerListener(this);
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHO " + this._name);
        }
        this.setInterpretor(new ChannelInterpretor(config));
    }

    public void release() {
        ((IRCServer)this._server).removeReplyServerListener(this);
        super.release();
    }

    public void addChannelListener(ChannelListener lis) {
        this._listeners.addListener(lis);
    }

    public void removeChannelListener(ChannelListener lis) {
        this._listeners.removeListener(lis);
    }

    public void addChannelListener2(ChannelListener2 lis) {
        this._listeners.addListener(lis);
    }

    public void removeChannelListener2(ChannelListener2 lis) {
        this._listeners.removeListener(lis);
    }

    public String getType() {
        return "Channel";
    }

    public String getName() {
        return this._name;
    }

    public boolean talkable() {
        return true;
    }

    public void leave() {
        this.getIRCServer().leaveChannel(this.getName());
    }

    public boolean hasNick(String nick) {
        return this._nicks.get(nick.toLowerCase(Locale.ENGLISH)) != null;
    }

    public void joinNick(String nick, String mode) {
        this._nicks.put(nick.toLowerCase(Locale.ENGLISH), new Nick(nick, mode, this.getIRCServer().getChannelModes(), this.getIRCServer().getNickModes()));
        if (this._ircConfiguration.getASLMaster()) {
            this.getIRCServer().execute("WHO " + nick);
        }
        this._listeners.sendEvent("nickJoin", nick, mode, this);
    }

    public void resetNicks() {
        this._nicks.clear();
        this._listeners.sendEvent("nickReset", this);
    }

    public void setNicks(String[] nicks, String[] modes) {
        for (int i = 0; i < nicks.length; ++i) {
            this._nicks.put(nicks[i].toLowerCase(Locale.ENGLISH), new Nick(nicks[i], modes[i], this.getIRCServer().getChannelModes(), this.getIRCServer().getNickModes()));
        }
        this._listeners.sendEvent("nickSet", nicks, modes, this);
    }

    public void partNick(String nick, String reason) {
        this._nicks.remove(nick.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickPart", nick, reason, this);
    }

    public void kickNick(String nick, String by, String reason) {
        this._nicks.remove(nick.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickKick", new Object[]{nick, by, reason, this});
    }

    public void quitNick(String nick, String reason) {
        this._nicks.remove(nick.toLowerCase(Locale.ENGLISH));
        this._listeners.sendEvent("nickQuit", nick, reason, this);
    }

    public String[] getNicks() {
        String[] ans = new String[this._nicks.size()];
        Enumeration e = this._nicks.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            ans[i++] = ((Nick)e.nextElement()).Name;
        }
        return ans;
    }

    public String getNickMode(String nick) {
        Nick n = (Nick)this._nicks.get(nick.toLowerCase(Locale.ENGLISH));
        if (n == null) {
            return null;
        }
        return n.Mode.getMode();
    }

    public void setTopic(String topic, String by) {
        this._topic = topic;
        this._listeners.sendEvent("topicChanged", topic, by, this);
    }

    public void applyUserMode(String nick, String mode, String from) {
        Nick n = (Nick)this._nicks.get(nick.toLowerCase(Locale.ENGLISH));
        if (n != null) {
            n.Mode.apply(mode);
        }
        this._listeners.sendEvent("nickModeApply", new Object[]{nick, mode, from, this});
    }

    public void applyMode(String mode, String from) {
        this._mode.apply(mode);
        this._listeners.sendEvent("modeApply", mode, from, this);
    }

    public String getMode() {
        return this._mode.getMode();
    }

    public String getTopic() {
        return this._topic;
    }

    public void changeNick(String oldNick, String newNick) {
        Nick n = (Nick)this._nicks.get(oldNick.toLowerCase(Locale.ENGLISH));
        this._nicks.remove(oldNick.toLowerCase(Locale.ENGLISH));
        n.Name = newNick;
        this._nicks.put(newNick.toLowerCase(Locale.ENGLISH), n);
        this._listeners.sendEvent("nickChanged", oldNick, newNick, this);
    }

    private void learn(String nick, String whois) {
        Nick n = (Nick)this._nicks.get(nick.toLowerCase(Locale.ENGLISH));
        if (n == null) {
            return;
        }
        n.Whois = whois;
        this._listeners.sendEvent("nickWhoisUpdated", nick, whois, this);
    }

    public String whois(String nick) {
        Nick n = (Nick)this._nicks.get(nick.toLowerCase(Locale.ENGLISH));
        if (n == null) {
            return "";
        }
        return n.Whois;
    }

    public Boolean replyReceived(String prefix, String id, String[] params, IRCServer server) {
        if (id.equals("352")) {
            String name = params[params.length - 1];
            int pos = name.indexOf(" ");
            if (pos != -1) {
                name = name.substring(pos + 1);
            }
            String nick = params[5];
            this.learn(nick, name);
        }
        return Boolean.FALSE;
    }
}

