/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCInterpretor;
import irc.IRCServer;
import irc.NotEnoughParametersException;
import irc.Server;
import irc.Source;

public class ChannelInterpretor
extends IRCInterpretor {
    public ChannelInterpretor(IRCConfiguration config) {
        super(config);
    }

    private boolean isChannel(String name, Source source) {
        if (name.length() == 0) {
            return false;
        }
        Server s = source.getServer();
        if (s instanceof IRCServer) {
            char[] prefixes = ((IRCServer)s).getChannelPrefixes();
            for (int i = 0; i < prefixes.length; ++i) {
                if (name.charAt(0) != prefixes[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        try {
            if (cmd.equals("part")) {
                if (parts.length == 1) {
                    this.sendString(source, "/part " + source.getName());
                } else if (this.isChannel(parts[1], source)) {
                    super.handleCommand(source, cmd, parts, cumul);
                } else {
                    this.sendString(source, "/part " + source.getName() + " " + cumul[1]);
                }
            } else if (cmd.equals("hop")) {
                this.sendString(source, "/part");
                this.sendString(source, "/join " + source.getName());
            } else if (cmd.equals("onotice")) {
                this.test(cmd, parts, 1);
                if (this.isChannel(parts[1], source)) {
                    super.handleCommand(source, cmd, parts, cumul);
                } else {
                    this.sendString(source, "/onotice " + source.getName() + " " + cumul[1]);
                }
            } else {
                super.handleCommand(source, cmd, parts, cumul);
            }
        }
        catch (NotEnoughParametersException ex) {
            source.report("\u00032      *** Invalid command format: " + ex.getMessage());
        }
    }
}

