/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.IRCConfiguration;
import irc.IRCObject;
import irc.MyPushbackStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CodingHandler
extends IRCObject {
    private MyPushbackStream _is;
    private OutputStream _os;
    private BufferedReader _reader;
    private BufferedWriter _writer;
    private int _coding;
    public static final int CODING_ASCII = 0;
    public static final int CODING_PUAP = 1;
    public static final int CODING_UTF_8 = 2;
    public static final int CODING_LOCAL_CHARSET = 3;

    public CodingHandler(IRCConfiguration config, InputStream is, OutputStream os) {
        super(config);
        this._coding = config.getI("coding");
        if (this._coding != 3) {
            this._is = new MyPushbackStream(is);
            this._os = os;
            this._reader = null;
            this._writer = null;
        } else {
            this._is = null;
            this._os = null;
            this._reader = new BufferedReader(new InputStreamReader(is));
            this._writer = new BufferedWriter(new OutputStreamWriter(os));
        }
    }

    public void close() throws IOException {
        if (this._is != null) {
            this._is.close();
        }
        if (this._os != null) {
            this._os.close();
        }
        if (this._reader != null) {
            this._reader.close();
        }
        if (this._writer != null) {
            this._writer.close();
        }
        this._is = null;
        this._os = null;
        this._reader = null;
        this._writer = null;
    }

    public String read() throws IOException {
        if (this._coding != 3) {
            String ans = this.readUTF();
            return CodingHandler.asciiToWide(ans);
        }
        return this._reader.readLine();
    }

    public void write(String s) throws IOException {
        if (this._coding == 0) {
            this.writeASCII(s);
        } else if (this._coding == 1) {
            this.writePUAP(s);
        } else if (this._coding == 2) {
            this.writeUTF(s);
        } else if (this._coding == 3) {
            this.writeCHARSET(s);
        } else {
            this.writePUAP(s);
        }
        if (this._os != null) {
            this._os.flush();
        }
        if (this._writer != null) {
            this._writer.flush();
        }
    }

    private void writeCHARSET(String s) throws IOException {
        this._writer.write(s, 0, s.length());
        this._writer.newLine();
    }

    private void writeASCII(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            this._os.write((byte)s.charAt(i));
        }
        this._os.write(13);
        this._os.write(10);
    }

    private void writePUAP(String s) throws IOException {
        this.writeASCII(CodingHandler.wideToAscii(s));
    }

    private String readUTF() throws IOException {
        String ans = "";
        String nonUTFans = "";
        boolean utf = true;
        char ch = '\u0000';
        int expect = 0;
        boolean terminated = false;
        while (!terminated) {
            int c = this._is.read();
            if ((c == 10 || c == 13) && nonUTFans.length() == 0) continue;
            if (c == -1) {
                if (nonUTFans.length() == 0) {
                    throw new IOException("EOF reached");
                }
                if (expect != 0) {
                    utf = false;
                }
                if (utf) {
                    return ans;
                }
                return nonUTFans;
            }
            if (c == 10 || c == 13) {
                if (expect != 0) {
                    utf = false;
                }
                if (this._is.available() >= 1) {
                    c = this._is.read();
                }
                if (c != 10 && c != 13) {
                    this._is.unread((byte)c);
                }
                if (utf) {
                    return ans;
                }
                return nonUTFans;
            }
            nonUTFans = nonUTFans + (char)c;
            if (!utf) continue;
            if (c < 128) {
                if (expect != 0) {
                    utf = false;
                    continue;
                }
                ans = ans + (char)c;
                continue;
            }
            if (c < 192) {
                if (expect == 0) {
                    utf = false;
                    continue;
                }
                ch = (char)(ch << 6 | c - 128 & 0x3F);
                if (--expect != 0) continue;
                ans = ans + ch;
                ch = '\u0000';
                continue;
            }
            if (c < 224) {
                if (expect != 0) {
                    utf = false;
                    continue;
                }
                expect = 1;
                ch = (char)(c - 192);
                continue;
            }
            if (expect != 0) {
                utf = false;
                continue;
            }
            expect = 2;
            ch = (char)(c - 224);
        }
        return null;
    }

    private void writeUTF(String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < '\u007f') {
                this._os.write((byte)ch);
                continue;
            }
            if (ch < '\u07ff') {
                this._os.write((byte)(192 + (ch >> 6)));
                this._os.write((byte)(128 + (ch & 0x3F)));
                continue;
            }
            this._os.write((byte)(224 + (ch >> 12)));
            this._os.write((byte)(128 + (ch >> 6 & 0x3F)));
            this._os.write((byte)(128 + (ch & 0x3F)));
        }
        this._os.write(10);
        this._os.write(13);
    }

    private static String asciiToWide(String str) {
        try {
            String res = "";
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '\u001e') {
                    String hex = str.substring(i + 1, i + 5);
                    i += 4;
                    int code = Integer.parseInt(hex, 16);
                    res = res + (char)code;
                    continue;
                }
                res = res + str.charAt(i);
            }
            return res;
        }
        catch (Exception ex) {
            return str;
        }
    }

    private static String wideToAscii(String str) {
        String res = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '\u00ff') {
                res = res + '\u001e';
                String v = Integer.toHexString(c);
                while (v.length() < 4) {
                    v = "0" + v;
                }
                res = res + v;
                continue;
            }
            res = res + (char)c;
        }
        return res;
    }
}

