/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AudioConfiguration;
import irc.FileHandler;
import irc.FileTextProvider;
import irc.IRCConfiguration;
import irc.ImageLoader;
import irc.ParameterProvider;
import irc.PrefixedParameterProvider;
import irc.ServerItem;
import irc.SoundHandler;
import irc.StartupConfiguration;
import irc.StringParser;
import irc.TextProvider;
import irc.URLHandler;
import java.awt.Color;
import java.awt.Font;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationLoader {
    private ParameterProvider _provider;
    private URLHandler _handler;
    private ImageLoader _loader;
    private SoundHandler _sound;
    private FileHandler _file;

    public ConfigurationLoader(ParameterProvider provider, URLHandler handler, ImageLoader loader, SoundHandler sound, FileHandler file) {
        this._provider = provider;
        this._handler = handler;
        this._loader = loader;
        this._sound = sound;
        this._file = file;
    }

    public IRCConfiguration loadIRCConfiguration() throws Exception {
        return this.getIRCConfiguration();
    }

    public StartupConfiguration loadStartupConfiguration() throws Exception {
        return this.getStartupConfiguration();
    }

    private String getParameter(String key) {
        return this._provider.getParameter(key);
    }

    private boolean getBoolean(String key, boolean def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        return (v = v.toLowerCase(Locale.ENGLISH).trim()).equals("true") || v.equals("on") || v.equals("1");
    }

    private String getString(String key, String def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        return v;
    }

    private int getInt(String key, int def) {
        String v = this.getParameter(key);
        if (v == null) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return def;
        }
    }

    private void readBackgroundConfig(IRCConfiguration config) {
        StringParser parser = new StringParser();
        String[] arr = this.getArray("style:backgroundimage");
        for (int i = 0; i < arr.length; ++i) {
            String cmd = arr[i];
            String[] back = parser.parseString(cmd);
            if (back.length < 4) continue;
            String type = back[0];
            String name = back[1];
            int tiling = new Integer(back[2]);
            String image = back[3];
            config.setBackgroundImage(type, name, image);
            config.setBackgroundTiling(type, name, tiling);
        }
    }

    private TextProvider getTextProvider() {
        String lang = this.getString("language", "english");
        String encoding = this.getString("languageencoding", "Unicode");
        String extension = this.getString("lngextension", "lng");
        String backlang = this.getString("backuplanguage", "english");
        String backencoding = this.getString("backuplanguageencoding", "");
        return new FileTextProvider(lang + "." + extension, encoding, backlang + "." + extension, backencoding, this._file);
    }

    private String[] getArray(String name) {
        String cmd;
        Vector<String> v = new Vector<String>();
        int i = 1;
        do {
            if ((cmd = this.getParameter(name + i)) != null) {
                v.insertElementAt(cmd, v.size());
            }
            ++i;
        } while (cmd != null);
        String[] ans = new String[v.size()];
        for (i = 0; i < v.size(); ++i) {
            ans[i] = (String)v.elementAt(i);
        }
        return ans;
    }

    private void readSmileys(IRCConfiguration config) {
        config.addSmiley("+us", "smileys/us.gif");
        config.addSmiley("%us", "smileys/usflag.gif");
        config.addSmiley("+ar", "smileys/ar.gif");
        config.addSmiley("+au", "smileys/au.gif");
        config.addSmiley("+be", "smileys/be.gif");
        config.addSmiley("+br", "smileys/br.gif");
        config.addSmiley("+ca", "smileys/ca.gif");
        config.addSmiley("%ca", "smileys/Canada.gif");
        config.addSmiley("+de", "smileys/de.gif");
        config.addSmiley("+eu", "smileys/eu.gif");
        config.addSmiley("%eu", "smileys/e-u.gif");
        config.addSmiley("+fr", "smileys/France.gif");
        config.addSmiley("+it", "smileys/it.gif");
        config.addSmiley("+jp", "smileys/jp.gif");
        config.addSmiley("+mx", "smileys/mexico.gif");
        config.addSmiley("+nl", "smileys/nl.gif");
        config.addSmiley("+no", "smileys/no.gif");
        config.addSmiley("+nr", "smileys/nr.gif");
        config.addSmiley("+pl", "smileys/pl.gif");
        config.addSmiley("%pl", "smileys/poland.gif");
        config.addSmiley("+uk", "smileys/UK.gif");
        config.addSmiley("+ve", "smileys/ve.gif");
        config.addSmiley("%ve", "smileys/venezuela.gif");
        config.addSmiley("(smile)", "smileys/smiley.gif");
        config.addSmiley(":D", "smileys/icon_biggrin.gif");
        config.addSmiley(":)", "smileys/icon_smile.gif");
        config.addSmiley(":(", "smileys/icon_sad.gif");
        config.addSmiley(":o", "smileys/icon_surprised.gif");
        config.addSmiley(":O", "smileys/icon_eek.gif");
        config.addSmiley("O.O", "smileys/icon_eek.gif");
        config.addSmiley(":?", "smileys/icon_confused.gif");
        config.addSmiley("8)", "smileys/icon_cool.gif");
        config.addSmiley("(lol)", "smileys/icon_lol.gif");
        config.addSmiley(":p", "smileys/icon_razz.gif");
        config.addSmiley(":s", "smileys/icon_confused.gif");
        config.addSmiley(":$", "smileys/icon_redface.gif");
        config.addSmiley(":'(", "smileys/icon_cry.gif");
        config.addSmiley(":@", "smileys/icon_mad.gif");
        config.addSmiley("(evil1)", "smileys/icon_twisted.gif");
        config.addSmiley("(evil)", "smileys/icon_evil.gif");
        config.addSmiley("(roll)", "smileys/icon_rolleyes.gif");
        config.addSmiley(";)", "smileys/icon_wink.gif");
        config.addSmiley("(!)", "smileys/icon_exclaim.gif");
        config.addSmiley("(?)", "smileys/icon_question.gif");
        config.addSmiley("(i)", "smileys/icon_idea.gif");
        config.addSmiley("(I)", "smileys/icon_idea.gif");
        config.addSmiley("(>)", "smileys/icon_arrow.gif");
        config.addSmiley(":|", "smileys/icon_neutral.gif");
        config.addSmiley("(greensmile)", "smileys/icon_mrgreen.gif");
        config.addSmiley("xD", "smileys/aiwebs_011.gif");
    }

    private void configureFonts(IRCConfiguration config) {
        StringParser parser = new StringParser();
        String[] arr = this.getArray("style:sourcefontrule");
        for (int i = 0; i < arr.length; ++i) {
            String cmd = arr[i];
            String[] back = parser.parseString(cmd);
            if (back.length < 4) continue;
            String type = back[0].toLowerCase(Locale.ENGLISH);
            String name = back[1].toLowerCase(Locale.ENGLISH);
            String fname = back[2].toLowerCase(Locale.ENGLISH);
            if (fname.startsWith("'") && fname.endsWith("'")) {
                fname = fname.substring(1, fname.length() - 1);
            }
            int fsize = new Integer(back[3].toLowerCase(Locale.ENGLISH));
            config.setFont(type, name, new Font(fname, 0, fsize));
        }
    }

    private void configureTextColors(IRCConfiguration config) {
        String[] arr = this.getArray("style:sourcecolorrule");
        for (int i = 0; i < arr.length; ++i) {
            StringTokenizer tok = new StringTokenizer(arr[i]);
            if (!tok.hasMoreElements()) continue;
            String type = (String)tok.nextElement();
            if (!tok.hasMoreElements()) continue;
            String name = (String)tok.nextElement();
            Color[] c = new Color[16];
            config.loadDefaultColors(c);
            while (tok.hasMoreElements()) {
                String s = (String)tok.nextElement();
                int pos = s.indexOf(61);
                if (pos < 0) continue;
                String before = s.substring(0, pos).trim();
                String after = s.substring(pos + 1).trim();
                int index = Integer.parseInt(before);
                Color col = new Color(Integer.parseInt(after, 16));
                if (index < 0 || index > 15) continue;
                c[index] = col;
            }
            config.setSourceColor(type, name, c);
        }
    }

    private void readSound(IRCConfiguration config) {
        AudioConfiguration ac = config.getAudioConfiguration();
        if (this.getParameter("soundbeep") != null) {
            ac.setBeep(this.getParameter("soundbeep"));
        }
        if (this.getParameter("soundquery") != null) {
            ac.setQuery(this.getParameter("soundquery"));
        }
        String[] arr = this.getArray("soundword");
        for (int i = 0; i < arr.length; ++i) {
            String cmd = arr[i];
            int pos = (cmd = cmd.trim()).indexOf(32);
            if (pos == -1) continue;
            String word = cmd.substring(0, pos).trim();
            String sound = cmd.substring(pos + 1).trim();
            ac.setWord(word, sound);
        }
    }

    private IRCConfiguration getIRCConfiguration() throws Exception {
        String gui = this.getString("gui", "pixx");
        IRCConfiguration config = new IRCConfiguration(this.getTextProvider(), this._handler, this._loader, this._sound, this._file, this._provider, new PrefixedParameterProvider(this._provider, gui + ":"));
        config.setJoinList(this.getString("authorizedjoinlist", "all"));
        config.setLeaveList(this.getString("authorizedleavelist", "all"));
        config.setCommandList(this.getString("authorizedcommandlist", "all-dcc-load-newserver-ping-raw-server-sleep-names"));
        config.set("style:floatingasl", this.getBoolean("style:floatingasl", false));
        config.set("style:floatingaslalpha", this.getInt("style:floatingaslalpha", 200));
        config.set("style:backgroundimage", this.getBoolean("style:backgroundimage", false));
        config.set("style:bitmapsmileys", this.getBoolean("style:bitmapsmileys", false));
        config.set("style:linespacing", this.getInt("style:linespacing", 2));
        config.set("style:maximumlinecount", this.getInt("style:maximumlinecount", 4096));
        config.set("style:highlightlinks", this.getBoolean("style:highlightlinks", false));
        config.set("aslseparatorstring", this.getString("aslseparatorstring", ""));
        config.set("noasldisplayprefix", this.getString("noasldisplayprefix", ""));
        config.set("quitmessage", this.getString("quitmessage", "User Quit"));
        config.set("asl", this.getBoolean("asl", false));
        config.set("aslmale", this.getString("aslmale", "m"));
        config.set("aslfemale", this.getString("aslfemale", "f"));
        config.set("useinfo", this.getBoolean("useinfo", true));
        config.set("coding", this.getInt("coding", 3));
        config.set("userid", this.getString("userid", "GatewayX"));
        config.set("style:righttoleft", this.getBoolean("style:righttoleft", false));
        config.set("autoconnection", this.getBoolean("autoconnection", false));
        config.set("useidentserver", this.getBoolean("useidentserver", false));
        config.set("multiserver", this.getBoolean("multiserver", false));
        config.set("aslunknown", this.getString("aslunknown", "x"));
        config.set("gui", this.getString("gui", "pixx"));
        config.set("fingerreply", this.getString("fingerreply", "i5Hx3Qh3Ji1Vx7Md9Kf2Pp9Xy5Y"));
        config.set("userinforeply", this.getString("userinforeply", "n0Cm2Vk9Rx7Dt9Fb2Cv7Ey8Fa9Cd3Yj6Iv4Zi3Kh5Jo4Iu3Gh9Bk8Od6Z"));
        config.set("allowdccchat", this.getBoolean("allowdccchat", false));
        config.set("allowdccfile", this.getBoolean("allowdccfile", false));
        config.set("disablequeries", this.getBoolean("disablequeries", false));
        config.set("autorejoin", this.getBoolean("autorejoin", false));
        config.setInitialisation(this.getArray("init"));
        this.readBackgroundConfig(config);
        this.readSmileys(config);
        this.configureFonts(config);
        this.configureTextColors(config);
        this.readSound(config);
        return config;
    }

    private ServerItem[] readServers(String dhost, int dport, String dpass) {
        Vector<ServerItem> res = new Vector<ServerItem>();
        ServerItem item = new ServerItem();
        item.host = dhost;
        item.port = new Integer(dport);
        item.pass = dpass;
        res.insertElementAt(item, res.size());
        String[] arr = this.getArray("alternateserver");
        for (int i = 0; i < arr.length; ++i) {
            String cmd = arr[i];
            int pos = cmd.indexOf(" ");
            if (pos < 0) continue;
            String host = cmd.substring(0, pos).trim();
            String port = cmd.substring(pos + 1).trim();
            String pass = "";
            pos = port.indexOf(" ");
            if (pos >= 0) {
                pass = port.substring(pos + 1).trim();
                port = port.substring(0, pos).trim();
            }
            item = new ServerItem();
            item.host = host;
            item.port = new Integer(port);
            item.pass = pass;
            res.insertElementAt(item, res.size());
        }
        ServerItem[] ans = new ServerItem[res.size()];
        for (int i = 0; i < ans.length; ++i) {
            ans[i] = (ServerItem)res.elementAt(i);
        }
        return ans;
    }

    private StartupConfiguration getStartupConfiguration() throws Exception {
        String alias;
        String sport;
        String pass;
        String host;
        String nick = this.getParameter("nick");
        if (nick == null) {
            throw new Exception("Your nickname cannot be blank, please choose another.");
        }
        String name = this.getParameter("name");
        if (name == null) {
            name = this.getParameter("fullname");
        }
        if (name == null) {
            name = "[P:RX{0,G}]";
        }
        if ((host = this.getParameter("host")) == null) {
            host = "chat.peercommons.net";
        }
        if ((pass = this.getParameter("password")) == null) {
            pass = "";
        }
        if ((sport = this.getParameter("port")) == null) {
            sport = "6667";
        }
        int port = new Integer(sport);
        String altNick = this.getParameter("alternatenick");
        if (altNick == null) {
            altNick = nick + "????";
        }
        if ((alias = this.getParameter("serveralias")) == null) {
            alias = "";
        }
        ServerItem[] items = this.readServers(host, port, pass);
        String[] hosts = new String[items.length];
        int[] ports = new int[items.length];
        String[] passs = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            hosts[i] = items[i].host;
            ports[i] = items[i].port;
            passs[i] = items[i].pass;
        }
        return new StartupConfiguration(nick, altNick, name, passs, hosts, ports, alias, this.getArray("command"), this.getArray("plugin"), true);
    }
}

