/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.NotEnoughParametersException;
import irc.PluginManager;
import irc.ServerManager;
import irc.Source;
import irc.StartupConfiguration;

public class DefaultInterpretor
extends BasicInterpretor {
    private StartupConfiguration _start;
    private ServerManager _mgr;
    private PluginManager _plugin;

    public DefaultInterpretor(IRCConfiguration config, StartupConfiguration start, ServerManager mgr, PluginManager plugin) {
        super(config);
        this._start = start;
        this._mgr = mgr;
        this._plugin = plugin;
    }

    protected void handleCommand(Source source, String cmd, String[] parts, String[] cumul) {
        try {
            if (cmd.equals("newserver")) {
                if (this._ircConfiguration.getB("multiserver")) {
                    this.test(cmd, parts, 2);
                    int port = 6667;
                    String pass = "";
                    String alias = parts[1];
                    if (parts.length > 3) {
                        port = new Integer(parts[3]);
                    }
                    if (parts.length > 4) {
                        pass = parts[4];
                    }
                    String host = parts[2];
                    IRCServer server = new IRCServer(this._ircConfiguration, this._mgr, this._start.getNick(), this._start.getAltNick(), this._start.getName(), alias);
                    server.setServers(new String[]{host}, new int[]{port}, new String[]{pass});
                    this._mgr.newServer(server, true);
                }
            } else if (cmd.equals("load")) {
                this.test(cmd, parts, 1);
                this._plugin.loadPlugin(parts[1]);
            } else if (cmd.equals("unload")) {
                this.test(cmd, parts, 1);
                this._plugin.unloadPlugin(parts[1]);
            } else {
                super.handleCommand(source, cmd, parts, cumul);
            }
        }
        catch (NotEnoughParametersException ex) {
            source.report("\u00032      *** Invalid command format: " + ex.getMessage());
        }
    }
}

