/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.EventDispatcher;
import irc.EventItem;
import irc.LinkedList;

class DispatchThread
extends Thread {
    private LinkedList _list;
    private Object _manageLock = new Object();
    private boolean _terminated = false;
    private boolean _processing = false;

    public DispatchThread(String type) {
        super(type + " event dispatch thread");
        this._list = new LinkedList();
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventItem addEvent(Object target, String method, Object[] params) {
        if (this._terminated) {
            return null;
        }
        EventItem item = new EventItem(target, method, params);
        Object object = this._manageLock;
        synchronized (object) {
            this._list.addLast(item);
            this._manageLock.notify();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int size = 0;
        do {
            EventItem item;
            Object object = this._manageLock;
            synchronized (object) {
                if (this._list.size() > 0) {
                    item = (EventItem)this._list.removeFirst();
                } else {
                    item = null;
                    try {
                        this._manageLock.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                size = this._list.size();
            }
            if (item == null) continue;
            this._processing = true;
            item.resultException = null;
            try {
                item.result = EventDispatcher.dispatchEventSyncEx(item.target, item.method, item.params);
            }
            catch (Throwable e) {
                item.resultException = e;
            }
            this._processing = false;
            object = item.endLock;
            synchronized (object) {
                item.resultAvailable = true;
                item.endLock.notify();
            }
        } while (!this._terminated || size != 0);
    }

    public void terminate() {
        this._terminated = true;
        if (!this._processing) {
            this.interrupt();
        }
    }
}

