/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.DispatchThread;
import irc.EventItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class EventDispatcher {
    private static final int USER = 0;
    private static final int SECURITY = 1;
    private static final String[] _names = new String[]{"User", "Security"};
    private static Hashtable _cache = new Hashtable();
    private static DispatchThread[] _thread = new DispatchThread[2];
    private static boolean _warning = true;

    private static void ensureAlive(int index) {
        if (_thread[index] == null || !_thread[index].isAlive()) {
            EventDispatcher._thread[index] = new DispatchThread(_names[index]);
        }
    }

    private static boolean match(Class[] t1, Class[] t2) {
        if (t1.length != t2.length) {
            return false;
        }
        for (int i = 0; i < t1.length; ++i) {
            if (t2[i] == null || t1[i].isAssignableFrom(t2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Hashtable hashtable = _cache;
        synchronized (hashtable) {
            _cache.clear();
        }
    }

    public static void disableBadThreadWarning() {
        _warning = false;
    }

    public static void enableBadThreadWarning() {
        _warning = true;
    }

    public static Object dispatchEventSync(Object target, String method, Object[] params) {
        try {
            return EventDispatcher.dispatchEventSyncEx(target, method, params);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventSyncEx(Object target, String method, Object[] params) throws Throwable {
        EventDispatcher.ensureAlive(0);
        if (method.startsWith("AWTSource")) {
            EventDispatcher.disableBadThreadWarning();
        }
        if (_warning && !EventDispatcher.isEventThread()) {
            System.err.println("Event dispatch in wrong thread for IRC method: " + method);
            System.err.println("expected thread was " + _thread);
            System.err.println("current thread is " + Thread.currentThread());
            System.err.println("please submit a bug report to bugs@frostwire.com with the following information :");
            Thread.dumpStack();
        }
        try {
            int i;
            Method[] m;
            Class<?> c = target.getClass();
            Hashtable hashtable = _cache;
            synchronized (hashtable) {
                m = (Method[])_cache.get(c);
                if (m == null) {
                    m = c.getMethods();
                    _cache.put(c, m);
                }
            }
            Class[] types = new Class[params.length];
            for (i = 0; i < params.length; ++i) {
                types[i] = params[i] != null ? params[i].getClass() : null;
            }
            for (i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(method) || !EventDispatcher.match(m[i].getParameterTypes(), types)) continue;
                return m[i].invoke(target, params);
            }
            throw new NoSuchMethodException(method);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            System.err.println("internal error");
            System.err.println("please submit a bug report to bugs@frostwire.com with the following information :");
            ex.printStackTrace();
            return null;
        }
    }

    public static void dispatchEventAsync(Object target, String method, Object[] params) {
        EventDispatcher.ensureAlive(0);
        _thread[0].addEvent(target, method, params);
    }

    private static void checkStack() {
    }

    private static void checkDeadLock(int index) {
        EventDispatcher.ensureAlive(index);
        if (Thread.currentThread() == _thread[index]) {
            try {
                throw new RuntimeException("Deadlock protection");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    public static void dispatchEventAsyncSecurity(Object target, String method, Object[] params) {
        EventDispatcher.checkStack();
        EventDispatcher.ensureAlive(1);
        _thread[1].addEvent(target, method, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object dispatchEventAsyncAndWaitExImp(Object target, String method, Object[] params, int index) throws InterruptedException, Throwable {
        EventDispatcher.checkDeadLock(index);
        EventDispatcher.ensureAlive(index);
        EventItem item = _thread[index].addEvent(target, method, params);
        Object object = item.endLock;
        synchronized (object) {
            if (item.resultAvailable) {
                if (item.resultException != null) {
                    throw item.resultException;
                }
                return item.result;
            }
            item.endLock.wait();
            if (item.resultException != null) {
                throw item.resultException;
            }
            return item.result;
        }
    }

    public static Object dispatchEventAsyncAndWaitEx(Object target, String method, Object[] params) throws InterruptedException, Throwable {
        return EventDispatcher.dispatchEventAsyncAndWaitExImp(target, method, params, 0);
    }

    public static Object dispatchEventAsyncAndWaitExSecurity(Object target, String method, Object[] params) throws InterruptedException, Throwable {
        EventDispatcher.checkStack();
        return EventDispatcher.dispatchEventAsyncAndWaitExImp(target, method, params, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object dispatchEventAsyncAndWait(Object target, String method, Object[] params) throws InterruptedException {
        EventDispatcher.checkDeadLock(0);
        EventDispatcher.ensureAlive(0);
        EventItem item = _thread[0].addEvent(target, method, params);
        Object object = item.endLock;
        synchronized (object) {
            if (item.resultAvailable) {
                return item.result;
            }
            item.endLock.wait();
            return item.result;
        }
    }

    public static boolean isEventThread() {
        EventDispatcher.ensureAlive(0);
        return Thread.currentThread() == _thread[0] || Thread.currentThread() == _thread[1];
    }
}

