/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.FileHandler;
import irc.TextProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;

public class FileTextProvider
implements TextProvider {
    private Hashtable _mainlist = new Hashtable();
    private Hashtable _backlist = new Hashtable();

    public FileTextProvider(String fname, String encoding, String backname, String backencoding, FileHandler file) {
        this.load(this._mainlist, fname, encoding, file);
        this.load(this._backlist, backname, backencoding, file);
    }

    private void parse(Hashtable dest, String line) {
        try {
            int pos = line.indexOf(32);
            if (pos == -1) {
                return;
            }
            String id = line.substring(0, pos);
            String end = line.substring(pos + 1).trim();
            if (line.indexOf(91) != -1) {
                pos = line.indexOf(93);
                if (pos == -1) {
                    return;
                }
                end = line.substring(pos + 1).trim();
            }
            int iid = Integer.parseInt(id, 16);
            end = this.replace(end, "\\s", " ");
            dest.put(new Integer(iid), end);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    private void load(Hashtable dest, String fname, String encoding, FileHandler handler) {
        InputStream stream = handler.getInputStream(fname);
        if (stream == null) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = encoding.length() > 0 ? new BufferedReader(new InputStreamReader(stream, encoding)) : new BufferedReader(new InputStreamReader(stream));
        }
        catch (Exception ex) {
            return;
        }
        try {
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    this.parse(dest, line);
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String replace(String on, String what, String with) {
        int pos = on.indexOf(what);
        while (pos >= 0) {
            String before = on.substring(0, pos);
            String after = on.substring(pos + what.length());
            on = before + with + after;
            pos = on.indexOf(what);
        }
        return on;
    }

    public String getString(int code, String[] params) {
        String ans = (String)this._mainlist.get(new Integer(code));
        if (ans == null) {
            ans = (String)this._backlist.get(new Integer(code));
        }
        if (ans == null) {
            ans = (String)this._mainlist.get(new Integer(65535));
        }
        if (ans == null) {
            ans = (String)this._backlist.get(new Integer(65535));
        }
        if (ans == null) {
            return this.getStringP(65535);
        }
        for (int i = params.length - 1; i >= 0; --i) {
            ans = this.replace(ans, "%" + (i + 1), params[i]);
        }
        return ans;
    }

    public String getString(int code) {
        return this.getString(code, new String[0]);
    }

    public String getString(int code, String p1) {
        String[] p = new String[]{p1};
        return this.getString(code, p);
    }

    public String getString(int code, String p1, String p2) {
        String[] p = new String[]{p1, p2};
        return this.getString(code, p);
    }

    public String getString(int code, String p1, String p2, String p3) {
        String[] p = new String[]{p1, p2, p3};
        return this.getString(code, p);
    }

    private String getStringP(int code) {
        switch (code) {
            case 65535: {
                return "Undefined string";
            }
        }
        return null;
    }
}

