/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.Channel;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.Query;
import irc.ServerManager;
import irc.Source;
import java.util.Date;
import java.util.Locale;

class FirstLineFilter {
    private IRCServer _server;
    private IRCConfiguration _ircConfiguration;
    private ServerManager _mgr;

    public FirstLineFilter(IRCServer serv, ServerManager mgr, IRCConfiguration config) {
        this._ircConfiguration = config;
        this._mgr = mgr;
        this._server = serv;
    }

    public void release() {
        this._mgr = null;
        this._server = null;
    }

    public boolean performFromChannelMessage(String channel, String nick, String msg) {
        Channel c;
        if (!msg.startsWith("\u0001")) {
            return false;
        }
        msg = msg.substring(1);
        msg = msg.substring(0, msg.length() - 1);
        String cmd = "";
        String param = "";
        int pos = msg.indexOf(32);
        if (pos == -1) {
            cmd = msg.toLowerCase(Locale.ENGLISH);
        } else {
            cmd = msg.substring(0, pos).toLowerCase(Locale.ENGLISH);
            param = msg.substring(pos + 1);
        }
        if (cmd.equals("action") && (c = this._server.getChannel(channel, false)) != null) {
            c.action(nick, param);
        }
        return true;
    }

    public boolean performFromNickMessage(String nick, String msg) {
        if (!msg.startsWith("\u0001")) {
            return false;
        }
        msg = msg.substring(1);
        msg = msg.substring(0, msg.length() - 1);
        String cmd = "";
        String param = "";
        int pos = msg.indexOf(32);
        if (pos == -1) {
            cmd = msg.toLowerCase(Locale.ENGLISH);
        } else {
            cmd = msg.substring(0, pos).toLowerCase(Locale.ENGLISH);
            param = msg.substring(pos + 1);
        }
        boolean show = true;
        if (cmd.equals("action")) {
            show = false;
            Query q = this._server.getQuery(nick, false);
            if (q != null) {
                q.action(nick, param);
            }
        } else if (cmd.equals("version")) {
            String data = "FrostWire Community Chat v0.4c";
            this._server.execute("NOTICE " + nick + " :\u0001VERSION " + data + " VKEY=46o1dkNwNXnVJ5YXttPc2NVyxtu02x8C" + "\u0001");
        } else if (cmd.equals("voidkey")) {
            this._server.execute("NOTICE " + nick + " :\u0001VOIDKEY" + " RE5q8M84Ifevpp622PpNfb2Iz4FPH4AL" + "\u0001");
        } else if (cmd.equals("expirekey")) {
            this._server.execute("NOTICE " + nick + " :\u0001EXPIREKEY" + " ezhw5C31hm3A0b0xnh7iG3iH1ZE17QsV" + "\u0001");
        } else if (cmd.equals("time")) {
            String data = new Date().toString();
            this._server.execute("NOTICE " + nick + " :\u0001TIME " + data + "\u0001");
        }
        return true;
    }

    public boolean performFromNotice(String nick, String msg) {
        if (!msg.startsWith("\u0001")) {
            return false;
        }
        msg = msg.substring(1);
        msg = msg.substring(0, msg.length() - 1);
        String cmd = "";
        String param = "";
        int pos = msg.indexOf(32);
        if (pos == -1) {
            cmd = msg.toLowerCase(Locale.ENGLISH);
        } else {
            cmd = msg.substring(0, pos).toLowerCase(Locale.ENGLISH);
            param = msg.substring(pos + 1);
        }
        Source source = this._server.getDefaultSource();
        if (cmd.equals("time")) {
            if (source != null) {
                source.report("\u000314***" + nick + "'s local time: " + param);
            }
            return true;
        }
        return true;
    }
}

